/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import glitchcore.event.entity.LivingEntityUseItemEvent;
import glitchcore.event.player.PlayerEvent;
import glitchcore.network.CustomPacket;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import toughasnails.api.damagesource.TANDamageTypes;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.init.ModConfig;
import toughasnails.init.ModPackets;
import toughasnails.init.ModTags;
import toughasnails.network.UpdateTemperaturePacket;
import toughasnails.temperature.BuiltInTemperatureModifier;
import toughasnails.temperature.TemperatureData;

public class TemperatureHandler {
    protected static final ResourceLocation SPEED_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"toughasnails", (String)"speed_modifier");

    public static void onPlayerTick(Player player) {
        if (!ModConfig.temperature.enableTemperature || player.level().isClientSide()) {
            return;
        }
        Level level = player.level();
        ITemperature data = TemperatureHelper.getTemperatureData(player);
        data.getNearbyThermoregulators().removeIf(pos -> level.getBlockEntity(pos) == null || player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) > 1024.0);
        data.setChangeDelayTicks(Math.max(0, data.getChangeDelayTicks() - 1));
        data.setDryTicks(data.getDryTicks() + 1);
        if (!player.hasEffect(TANEffects.CLIMATE_CLEMENCY)) {
            int changeDelay = ModConfig.temperature.temperatureChangeDelay;
            TemperatureLevel currentTargetLevel = data.getTargetLevel();
            TemperatureLevel newTargetLevel = TemperatureHelper.getTemperatureAtPos(player.level(), player.blockPosition());
            for (BuiltInTemperatureModifier modifier : BuiltInTemperatureModifier.getTemperatureModifierOrder()) {
                Tuple<TemperatureLevel, Integer> output = modifier.apply(player, newTargetLevel, changeDelay);
                newTargetLevel = (TemperatureLevel)((Object)output.getA());
                changeDelay = (Integer)output.getB();
            }
            if (newTargetLevel != currentTargetLevel) {
                data.setTargetLevel(newTargetLevel);
                if ((data.getLevel() == TemperatureLevel.ICY || data.getLevel() == TemperatureLevel.HOT) && newTargetLevel != TemperatureLevel.ICY && newTargetLevel != TemperatureLevel.HOT) {
                    changeDelay = Math.min(changeDelay, ModConfig.temperature.extremityReboundTemperatureChangeDelay);
                }
                data.setChangeDelayTicks(changeDelay);
            }
            if (data.getChangeDelayTicks() == 0 && currentTargetLevel != data.getLevel()) {
                data.setLevel(data.getLevel().increment(Mth.sign((double)(data.getTargetLevel().ordinal() - data.getLevel().ordinal()))));
                data.setChangeDelayTicks(changeDelay);
            }
        } else {
            data.setLevel(TemperatureLevel.NEUTRAL);
        }
        data.setExtremityDelayTicks(Math.max(0, data.getExtremityDelayTicks() - 1));
        if (data.getLastLevel() != data.getLevel() && (data.getLevel() == TemperatureLevel.ICY || data.getLevel() == TemperatureLevel.HOT)) {
            data.setExtremityDelayTicks(ModConfig.temperature.extremityDamageDelay);
        }
        int hyperthermicTicks = data.getHyperthermiaTicks();
        int ticksToHyperthermia = TemperatureHelper.getTicksRequiredForHyperthermia();
        if (!player.isCreative() && !player.isSpectator()) {
            if (!player.hasEffect(MobEffects.FIRE_RESISTANCE) && data.getLevel() == TemperatureLevel.HOT && data.getExtremityDelayTicks() == 0) {
                data.setHyperthermiaTicks(Math.min(ticksToHyperthermia, hyperthermicTicks + 1));
            } else {
                data.setHyperthermiaTicks(Math.max(0, hyperthermicTicks - 2));
            }
        } else if (data.getHyperthermiaTicks() > 0) {
            data.setHyperthermiaTicks(Math.max(0, hyperthermicTicks - 2));
        }
        TemperatureHandler.removeHeatExhaustion(player);
        TemperatureHandler.tryAddHeatExhaustion(player);
        if (player.tickCount % 40 == 0 && TemperatureHelper.isFullyHyperthermic(player)) {
            player.hurt(player.damageSources().source(TANDamageTypes.HYPERTHERMIA), 1.0f);
        }
    }

    public static void onChangeDimension(PlayerEvent.ChangeDimension event) {
        ITemperature temperature = TemperatureHelper.getTemperatureData(event.getPlayer());
        temperature.setLastLevel(TemperatureData.DEFAULT_LEVEL);
        temperature.setLastHyperthermiaTicks(0);
        temperature.setLastNearbyThermoregulators(new HashSet<BlockPos>());
    }

    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (!ModConfig.temperature.enableTemperature || !(event.getEntity() instanceof Player) || event.getEntity().level().isClientSide()) {
            return;
        }
        Player player = (Player)event.getEntity();
        ItemStack item = event.getItem();
        if (item.is(ModTags.Items.COOLING_CONSUMED_ITEMS)) {
            player.addEffect(new MobEffectInstance(TANEffects.INTERNAL_CHILL, ModConfig.temperature.consumableEffectDuration, 0, false, false, true));
        }
        if (item.is(ModTags.Items.HEATING_CONSUMED_ITEMS)) {
            player.addEffect(new MobEffectInstance(TANEffects.INTERNAL_WARMTH, ModConfig.temperature.consumableEffectDuration, 0, false, false, true));
        }
    }

    public static void syncTemperature(ServerPlayer player) {
        ITemperature temperature = TemperatureHelper.getTemperatureData((Player)player);
        ModPackets.HANDLER.sendToPlayer((CustomPacket)new UpdateTemperaturePacket(temperature.getLevel(), temperature.getHyperthermiaTicks(), temperature.getNearbyThermoregulators()), player);
        temperature.setLastLevel(temperature.getLevel());
        temperature.setLastHyperthermiaTicks(temperature.getHyperthermiaTicks());
        temperature.setNearbyThermoregulators(temperature.getNearbyThermoregulators());
    }

    private static void removeHeatExhaustion(Player player) {
        AttributeInstance attribute = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (attribute != null && attribute.getModifier(SPEED_MODIFIER_ID) != null) {
            attribute.removeModifier(SPEED_MODIFIER_ID);
        }
    }

    protected static void tryAddHeatExhaustion(Player player) {
        int ticks;
        if (!player.level().getBlockState(player.getOnPos()).isAir() && (ticks = TemperatureHelper.getTicksHyperthermic(player)) > 0) {
            AttributeInstance attributeinstance = player.getAttribute(Attributes.MOVEMENT_SPEED);
            if (attributeinstance == null) {
                return;
            }
            float f = 0.015f * TemperatureHelper.getPercentHyperthermic(player);
            attributeinstance.addTransientModifier(new AttributeModifier(SPEED_MODIFIER_ID, (double)f, AttributeModifier.Operation.ADD_VALUE));
        }
    }
}

