/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.thirst;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.GameRules;
import toughasnails.api.damagesource.TANDamageTypes;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.init.ModConfig;

public class ThirstHooks {
    public static void onCauseFoodExhaustion(Player player, float exhaustion) {
        if (ModConfig.thirst.enableThirst) {
            ThirstHelper.getThirst(player).addExhaustion(exhaustion);
        }
    }

    public static void doFoodDataTick(FoodData data, ServerPlayer player) {
        boolean naturalRegen;
        Difficulty difficulty = player.level().getDifficulty();
        IThirst thirst = ThirstHelper.getThirst((Player)player);
        if (data.exhaustionLevel > 4.0f) {
            data.exhaustionLevel -= 4.0f;
            if (data.saturationLevel > 0.0f) {
                data.saturationLevel = Math.max(data.saturationLevel - 1.0f, 0.0f);
            } else if (difficulty != Difficulty.PEACEFUL) {
                data.foodLevel = Math.max(data.foodLevel - 1, 0);
            }
        }
        if ((naturalRegen = player.level().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION)) && data.saturationLevel > 0.0f && player.isHurt() && data.foodLevel >= 20 && (!ModConfig.thirst.thirstPreventHealthRegen || thirst.getHydration() > 0.0f && thirst.getThirst() >= 20)) {
            ++data.tickTimer;
            if (data.tickTimer >= 10) {
                float replenishAmount = Math.min(data.saturationLevel, 6.0f);
                player.heal(replenishAmount / 6.0f);
                data.addExhaustion(replenishAmount);
                thirst.addExhaustion(replenishAmount);
                data.tickTimer = 0;
            }
        } else if (naturalRegen && data.foodLevel >= 18 && (!ModConfig.thirst.thirstPreventHealthRegen || thirst.getThirst() >= 18) && player.isHurt()) {
            ++data.tickTimer;
            if (data.tickTimer >= 80) {
                player.heal(1.0f);
                data.addExhaustion(6.0f);
                thirst.addExhaustion(6.0f);
                data.tickTimer = 0;
            }
        } else if (data.foodLevel <= 0) {
            ++data.tickTimer;
            if (data.tickTimer >= 80) {
                if (player.getHealth() > 10.0f || difficulty == Difficulty.HARD || player.getHealth() > 1.0f && difficulty == Difficulty.NORMAL) {
                    player.hurt(player.damageSources().source(TANDamageTypes.THIRST), 1.0f);
                }
                data.tickTimer = 0;
            }
        } else {
            data.tickTimer = 0;
        }
    }
}

