/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.block;

import com.mojang.serialization.MapCodec;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import toughasnails.api.blockentity.TANBlockEntityTypes;
import toughasnails.api.particle.TANParticles;
import toughasnails.block.WaterPurifierBlock;
import toughasnails.block.entity.ThermoregulatorBlockEntity;

public class ThermoregulatorBlock
extends BaseEntityBlock {
    public static final MapCodec<WaterPurifierBlock> CODEC = ThermoregulatorBlock.simpleCodec(WaterPurifierBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty COOLING = BooleanProperty.create((String)"cooling");
    public static final BooleanProperty HEATING = BooleanProperty.create((String)"heating");
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;

    public ThermoregulatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)COOLING, (Comparable)Boolean.valueOf(false))).setValue((Property)HEATING, (Comparable)Boolean.valueOf(false))).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(state.getMenuProvider(level, pos));
        return InteractionResult.CONSUME;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ThermoregulatorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide() ? null : ThermoregulatorBlock.createTickerHelper(type, TANBlockEntityTypes.THERMOREGULATOR, ThermoregulatorBlockEntity::serverTick);
    }

    public static ToIntFunction<BlockState> lightLevel(int level) {
        return state -> {
            boolean cooling = (Boolean)state.getValue((Property)COOLING);
            boolean heating = (Boolean)state.getValue((Property)HEATING);
            return ((cooling ? 1 : 0) + (heating ? 1 : 0)) * level;
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext $$0) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)$$0.getHorizontalDirection().getOpposite())).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public BlockState rotate(BlockState $$0, Rotation $$1) {
        return (BlockState)$$0.setValue(FACING, (Comparable)$$1.rotate((Direction)$$0.getValue(FACING)));
    }

    public BlockState mirror(BlockState $$0, Mirror $$1) {
        return $$0.rotate($$1.getRotation((Direction)$$0.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, COOLING, HEATING, ENABLED});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void onPlace(BlockState state, Level level, BlockPos $$2, BlockState $$3, boolean $$4) {
        if (!$$3.is(state.getBlock())) {
            this.checkPoweredState(level, $$2, state);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, Orientation orientation, boolean movedByPiston) {
        this.checkPoweredState(level, pos, state);
    }

    private void checkPoweredState(Level level, BlockPos pos, BlockState state) {
        boolean flag;
        boolean bl = flag = !level.hasNeighborSignal(pos);
        if (flag != (Boolean)state.getValue((Property)ENABLED)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos, Direction direction) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    public void animateTick(BlockState p_221253_, Level p_221254_, BlockPos p_221255_, RandomSource p_221256_) {
        boolean cooling = (Boolean)p_221253_.getValue((Property)COOLING);
        boolean heating = (Boolean)p_221253_.getValue((Property)HEATING);
        Direction direction = (Direction)p_221253_.getValue(FACING);
        Direction.Axis direction$axis = direction.getAxis();
        BlockPos blockpos = p_221255_.relative(direction);
        BlockState blockstate = p_221254_.getBlockState(blockpos);
        if ((cooling || heating) && !ThermoregulatorBlock.isFaceFull((VoxelShape)blockstate.getCollisionShape((BlockGetter)p_221254_, blockpos), (Direction)direction.getOpposite())) {
            double d0 = (double)p_221255_.getX() + 0.5;
            double d1 = (double)p_221255_.getY() + 0.5;
            double d2 = (double)p_221255_.getZ() + 0.5;
            double d4 = p_221256_.nextDouble() * 0.3 - p_221256_.nextDouble() * 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.getStepX() * 0.55 : d4;
            double d6 = direction$axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.55 : d4;
            double ymove = p_221256_.nextDouble() * 0.05 - p_221256_.nextDouble() * 0.05;
            double xmove = direction$axis == Direction.Axis.X ? (double)direction.getStepX() * 0.15 : ymove;
            double zmove = direction$axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.15 : ymove;
            SimpleParticleType particle = TANParticles.THERMOREGULATOR_NEUTRAL;
            if (cooling && !heating) {
                particle = TANParticles.THERMOREGULATOR_COOL;
            }
            if (!cooling && heating) {
                particle = TANParticles.THERMOREGULATOR_WARM;
            }
            p_221254_.addParticle((ParticleOptions)particle, d0 + d5, d1 + d4, d2 + d6, xmove, ymove, zmove);
        }
    }
}

