/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.block.entity;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import toughasnails.api.blockentity.TANBlockEntityTypes;
import toughasnails.api.crafting.TANRecipeTypes;
import toughasnails.block.WaterPurifierBlock;
import toughasnails.container.WaterPurifierMenu;
import toughasnails.crafting.WaterPurifierRecipe;

public class WaterPurifierBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FILTER = 1;
    protected static final int SLOT_RESULT = 2;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    private NonNullList<ItemStack> items = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    private int filterTimeRemaining;
    private int filterDuration;
    private int purifyProgress;
    private int purifyTotalTime;
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends Recipe<SingleRecipeInput>> quickCheck;
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return WaterPurifierBlockEntity.this.filterTimeRemaining;
                }
                case 1: {
                    return WaterPurifierBlockEntity.this.filterDuration;
                }
                case 2: {
                    return WaterPurifierBlockEntity.this.purifyProgress;
                }
                case 3: {
                    return WaterPurifierBlockEntity.this.purifyTotalTime;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    WaterPurifierBlockEntity.this.filterTimeRemaining = value;
                    break;
                }
                case 1: {
                    WaterPurifierBlockEntity.this.filterDuration = value;
                    break;
                }
                case 2: {
                    WaterPurifierBlockEntity.this.purifyProgress = value;
                    break;
                }
                case 3: {
                    WaterPurifierBlockEntity.this.purifyTotalTime = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public WaterPurifierBlockEntity(BlockPos pos, BlockState state) {
        super(TANBlockEntityTypes.WATER_PURIFIER, pos, state);
        this.quickCheck = RecipeManager.createCheck(TANRecipeTypes.WATER_PURIFYING);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)input, this.items);
        this.filterTimeRemaining = input.getInt("FilterTimeRemaining").orElse(0);
        this.filterDuration = input.getInt("FilterDuration").orElse(0);
        this.purifyProgress = input.getInt("PurifyProgress").orElse(0);
        this.purifyTotalTime = input.getInt("PurifyTotalTime").orElse(0);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putInt("FilterTimeRemaining", this.filterTimeRemaining);
        output.putInt("FilterDuration", this.filterDuration);
        output.putInt("PurifyProgress", this.purifyProgress);
        output.putInt("PurifyTotalTime", this.purifyTotalTime);
        ContainerHelper.saveAllItems((ValueOutput)output, this.items);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, WaterPurifierBlockEntity blockEntity) {
        ItemStack filterStack;
        boolean hasFilter;
        boolean previouslyFiltering = blockEntity.isFiltering();
        boolean changed = false;
        if (blockEntity.isFiltering()) {
            --blockEntity.filterTimeRemaining;
        }
        boolean bl = hasFilter = !(filterStack = (ItemStack)blockEntity.items.get(1)).isEmpty();
        if (blockEntity.isFiltering() || hasFilter && !((ItemStack)blockEntity.items.get(0)).isEmpty()) {
            RecipeHolder recipe = blockEntity.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput((ItemStack)blockEntity.items.get(0)), (ServerLevel)level).orElse(null);
            if (recipe != null) {
                if (!blockEntity.isFiltering() && blockEntity.canFilter((Recipe<SingleRecipeInput>)recipe.value())) {
                    blockEntity.filterDuration = blockEntity.filterTimeRemaining = WaterPurifierBlockEntity.getFilterDuration(filterStack);
                    if (blockEntity.isFiltering()) {
                        changed = true;
                        if (hasFilter) {
                            Item filter = filterStack.getItem();
                            filterStack.shrink(1);
                            if (filterStack.isEmpty()) {
                                blockEntity.items.set(1, (Object)filter.getCraftingRemainder());
                            }
                        }
                    }
                }
                if (blockEntity.isFiltering() && blockEntity.canFilter((Recipe<SingleRecipeInput>)recipe.value())) {
                    ++blockEntity.purifyProgress;
                    if (blockEntity.purifyProgress == blockEntity.purifyTotalTime) {
                        blockEntity.purifyProgress = 0;
                        blockEntity.purifyTotalTime = blockEntity.getTotalPurifyTime();
                        blockEntity.filter((Recipe<SingleRecipeInput>)recipe.value());
                        changed = true;
                    }
                } else {
                    blockEntity.purifyProgress = 0;
                }
            } else if (!blockEntity.isFiltering() && blockEntity.purifyProgress > 0) {
                blockEntity.purifyProgress = Mth.clamp((int)(blockEntity.purifyProgress - 2), (int)0, (int)blockEntity.purifyTotalTime);
            }
        }
        if (previouslyFiltering != blockEntity.isFiltering()) {
            changed = true;
            state = (BlockState)state.setValue((Property)WaterPurifierBlock.PURIFYING, (Comparable)Boolean.valueOf(blockEntity.isFiltering()));
            level.setBlock(pos, state, 3);
        }
        if (changed) {
            WaterPurifierBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return new WaterPurifierMenu(id, player, (Container)this, this.dataAccess);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.toughasnails.water_purifier");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public int[] getSlotsForFace(Direction side) {
        switch (side) {
            case DOWN: {
                return SLOTS_FOR_DOWN;
            }
            case UP: {
                return SLOTS_FOR_UP;
            }
        }
        return SLOTS_FOR_SIDES;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (slot == 2) {
            return false;
        }
        if (slot != 1) {
            return true;
        }
        return WaterPurifierBlockEntity.isFilter(stack);
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return direction != Direction.DOWN || index != 1;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.items, (int)index, (int)count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.items, (int)index);
    }

    public void setItem(int index, ItemStack stack) {
        ItemStack currentStack = (ItemStack)this.items.get(index);
        boolean sameItem = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)currentStack);
        this.items.set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        if (index == 0 && !sameItem) {
            this.purifyTotalTime = this.getTotalPurifyTime();
            this.purifyProgress = 0;
            this.setChanged();
        }
    }

    public boolean stillValid(Player player) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public void clearContent() {
        this.items.clear();
    }

    public boolean isFiltering() {
        return this.filterTimeRemaining > 0;
    }

    protected boolean canFilter(@Nullable Recipe<SingleRecipeInput> recipe) {
        if (!((ItemStack)this.items.get(0)).isEmpty() && recipe != null) {
            ItemStack input = (ItemStack)this.items.get(0);
            ItemStack recipeResult = recipe.assemble((RecipeInput)new SingleRecipeInput(input), (HolderLookup.Provider)this.level.registryAccess());
            if (recipeResult.isEmpty()) {
                return false;
            }
            ItemStack currentResult = (ItemStack)this.items.get(2);
            if (currentResult.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItem((ItemStack)currentResult, (ItemStack)recipeResult)) {
                return false;
            }
            if (currentResult.getCount() + recipeResult.getCount() <= this.getMaxStackSize() && currentResult.getCount() + recipeResult.getCount() <= currentResult.getMaxStackSize()) {
                return true;
            }
            return currentResult.getCount() + recipeResult.getCount() <= recipeResult.getMaxStackSize();
        }
        return false;
    }

    protected int getTotalPurifyTime() {
        SingleRecipeInput singlerecipeinput = new SingleRecipeInput((ItemStack)this.items.get(0));
        return this.quickCheck.getRecipeFor((RecipeInput)singlerecipeinput, (ServerLevel)this.level).map(p_379263_ -> ((WaterPurifierRecipe)p_379263_.value()).getPurifyTime()).orElse(200);
    }

    private void filter(@Nullable Recipe<SingleRecipeInput> recipe) {
        if (recipe != null && this.canFilter(recipe)) {
            ItemStack input = (ItemStack)this.items.get(0);
            ItemStack recipeResult = recipe.assemble((RecipeInput)new SingleRecipeInput(input), (HolderLookup.Provider)this.level.registryAccess());
            ItemStack currentResult = (ItemStack)this.items.get(2);
            if (currentResult.isEmpty()) {
                this.items.set(2, (Object)recipeResult.copy());
            } else if (currentResult.getItem() == recipeResult.getItem()) {
                currentResult.grow(recipeResult.getCount());
            }
            input.shrink(1);
        }
    }

    public static boolean isFilter(ItemStack stack) {
        return WaterPurifierBlockEntity.getFilterDuration(stack) > 0;
    }

    public static int getFilterDuration(ItemStack filter) {
        if (filter == null || filter.isEmpty()) {
            return 0;
        }
        return (Integer)WaterPurifierBlockEntity.getFilterDurations().getOrDefault((Object)filter.getItem(), (Object)0);
    }

    private static ImmutableMap<Item, Integer> getFilterDurations() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        WaterPurifierBlockEntity.add((ImmutableMap.Builder<Item, Integer>)builder, Items.SHORT_GRASS, 100);
        WaterPurifierBlockEntity.add((ImmutableMap.Builder<Item, Integer>)builder, Items.PAPER, 200);
        WaterPurifierBlockEntity.add((ImmutableMap.Builder<Item, Integer>)builder, Items.GRAVEL, 400);
        WaterPurifierBlockEntity.add((ImmutableMap.Builder<Item, Integer>)builder, (TagKey<Item>)ItemTags.SAND, 800);
        WaterPurifierBlockEntity.add((ImmutableMap.Builder<Item, Integer>)builder, Items.CHARCOAL, 1600);
        WaterPurifierBlockEntity.add((ImmutableMap.Builder<Item, Integer>)builder, Items.PRISMARINE_CRYSTALS, 3200);
        WaterPurifierBlockEntity.add((ImmutableMap.Builder<Item, Integer>)builder, Items.HEART_OF_THE_SEA, 6400);
        return builder.build();
    }

    private static void add(ImmutableMap.Builder<Item, Integer> builder, TagKey<Item> tagKey, int i) {
        for (Holder holder : BuiltInRegistries.ITEM.getTagOrEmpty(tagKey)) {
            builder.put((Object)((Item)holder.value()), (Object)i);
        }
    }

    private static void add(ImmutableMap.Builder<Item, Integer> builder, Item item, int i) {
        builder.put((Object)item, (Object)i);
    }
}

