/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import toughasnails.container.WaterPurifierMenu;

public class WaterPurifierScreen
extends AbstractContainerScreen<WaterPurifierMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"toughasnails", (String)"textures/gui/container/water_purifier.png");

    public WaterPurifierScreen(WaterPurifierMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    public void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(gui, mouseX, mouseY, partialTicks);
        super.render(gui, mouseX, mouseY, partialTicks);
        this.renderTooltip(gui, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        int leftPos = this.leftPos;
        int topPos = this.topPos;
        gui.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, leftPos, topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        if (((WaterPurifierMenu)this.menu).isFiltering()) {
            int filterProgress = ((WaterPurifierMenu)this.menu).getFilterProgress();
            gui.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, leftPos + 56 + 1, topPos + 36 + 13 - filterProgress, 176.0f, (float)(13 - filterProgress), 14, filterProgress + 1, 256, 256);
        }
        int purifyProgress = ((WaterPurifierMenu)this.menu).getPurifyProgress();
        gui.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, leftPos + 79, topPos + 34, 176.0f, 14.0f, purifyProgress + 1, 16, 256, 256);
    }
}

