/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import toughasnails.api.crafting.TANRecipeBookCategories;
import toughasnails.api.crafting.TANRecipeSerializers;
import toughasnails.api.crafting.TANRecipeTypes;

public class WaterPurifierRecipe
implements Recipe<SingleRecipeInput> {
    protected final ItemStack input;
    protected final ItemStack result;
    protected final int purifyTime;
    @Nullable
    private PlacementInfo placementInfo;

    public WaterPurifierRecipe(ItemStack input, ItemStack result, int purifyTime) {
        this.input = input;
        this.result = result;
        this.purifyTime = purifyTime;
    }

    public boolean matches(SingleRecipeInput input, Level var2) {
        if (this.input == null) {
            return false;
        }
        ItemStack containerInput = input.getItem(0);
        return ItemStack.isSameItemSameComponents((ItemStack)this.input, (ItemStack)containerInput) && this.input.getDamageValue() == containerInput.getDamageValue();
    }

    public ItemStack assemble(SingleRecipeInput var1, HolderLookup.Provider var2) {
        return this.result.copy();
    }

    public ItemStack input() {
        return this.input;
    }

    protected ItemStack result() {
        return this.result;
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create((Ingredient)Ingredient.of((ItemLike)this.input.getItem()));
        }
        return this.placementInfo;
    }

    public RecipeBookCategory recipeBookCategory() {
        return TANRecipeBookCategories.WATER_PURIFYING;
    }

    public RecipeSerializer<? extends Recipe<SingleRecipeInput>> getSerializer() {
        return TANRecipeSerializers.WATER_PURIFYING;
    }

    public RecipeType<? extends Recipe<SingleRecipeInput>> getType() {
        return TANRecipeTypes.WATER_PURIFYING;
    }

    public int getPurifyTime() {
        return this.purifyTime;
    }

    public static class Serializer
    implements RecipeSerializer<WaterPurifierRecipe> {
        private static final MapCodec<WaterPurifierRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemStack.CODEC.fieldOf("input").forGetter(p_296920_ -> p_296920_.input), (App)ItemStack.CODEC.fieldOf("result").forGetter(p_296923_ -> p_296923_.result), (App)Codec.INT.fieldOf("purifytime").orElse((Object)200).forGetter(p_296919_ -> p_296919_.purifyTime)).apply((Applicative)builder, WaterPurifierRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, WaterPurifierRecipe> streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);

        public WaterPurifierRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ItemStack input = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int purifyTime = buffer.readInt();
            return new WaterPurifierRecipe(input, result, purifyTime);
        }

        public void toNetwork(RegistryFriendlyByteBuf buffer, WaterPurifierRecipe recipe) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeInt(recipe.purifyTime);
        }

        public MapCodec<WaterPurifierRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, WaterPurifierRecipe> streamCodec() {
            return this.streamCodec;
        }
    }
}

