/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import toughasnails.api.block.TANBlocks;
import toughasnails.api.blockentity.TANBlockEntityTypes;
import toughasnails.block.entity.TemperatureGaugeBlockEntity;
import toughasnails.block.entity.ThermoregulatorBlockEntity;
import toughasnails.block.entity.WaterPurifierBlockEntity;

public class ModBlockEntities {
    public static void registerBlockEntities(BiConsumer<ResourceLocation, BlockEntityType<?>> func) {
        TANBlockEntityTypes.WATER_PURIFIER = ModBlockEntities.register(func, "water_purifier", WaterPurifierBlockEntity::new, Set.of(TANBlocks.WATER_PURIFIER));
        TANBlockEntityTypes.TEMPERATURE_GAUGE = ModBlockEntities.register(func, "temperature_gauge", TemperatureGaugeBlockEntity::new, Set.of(TANBlocks.TEMPERATURE_GAUGE));
        TANBlockEntityTypes.THERMOREGULATOR = ModBlockEntities.register(func, "thermoregulator", ThermoregulatorBlockEntity::new, Set.of(TANBlocks.THERMOREGULATOR));
    }

    private static <T extends BlockEntity> BlockEntityType<?> register(BiConsumer<ResourceLocation, BlockEntityType<?>> func, String name, BlockEntityType.BlockEntitySupplier<T> supplier, Set<Block> blocks) {
        BlockEntityType type = new BlockEntityType(supplier, blocks);
        func.accept(ResourceLocation.fromNamespaceAndPath((String)"toughasnails", (String)name), type);
        return type;
    }
}

