/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import toughasnails.api.enchantment.TANEnchantments;
import toughasnails.api.player.ITANPlayer;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.temperature.IPlayerTemperatureModifier;
import toughasnails.api.temperature.IPositionalTemperatureModifier;
import toughasnails.api.temperature.IProximityBlockModifier;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.block.entity.ThermoregulatorBlockEntity;
import toughasnails.init.ModConfig;
import toughasnails.init.ModTags;
import toughasnails.temperature.AreaFill;

public class TemperatureHelperImpl
implements TemperatureHelper.Impl.ITemperatureHelper {
    protected static List<IPositionalTemperatureModifier> positionalModifiers = Lists.newArrayList((Object[])new IPositionalTemperatureModifier[]{TemperatureHelperImpl::altitudeModifier, TemperatureHelperImpl::rainModifier});
    protected static List<IProximityBlockModifier> proximityModifiers = new ArrayList<IProximityBlockModifier>();
    protected static List<IPlayerTemperatureModifier> playerModifiers = Lists.newArrayList((Object[])new IPlayerTemperatureModifier[]{TemperatureHelperImpl::thermoregulatorModifier, TemperatureHelperImpl::immersionModifier});

    @Override
    public TemperatureLevel getTemperatureAtPos(Level level, BlockPos pos) {
        TemperatureLevel temperature = TemperatureHelperImpl.getBiomeTemperatureLevel(level, pos);
        temperature = TemperatureHelperImpl.nightModifier(level, pos, temperature);
        for (IPositionalTemperatureModifier modifier : positionalModifiers) {
            temperature = modifier.modify(level, pos, temperature);
        }
        return TemperatureHelperImpl.proximityModifier(level, pos, temperature);
    }

    public static TemperatureLevel getTemperatureAtPosWithoutProximity(Level level, BlockPos pos) {
        TemperatureLevel temperature = TemperatureHelperImpl.getBiomeTemperatureLevel(level, pos);
        temperature = TemperatureHelperImpl.nightModifier(level, pos, temperature);
        for (IPositionalTemperatureModifier modifier : positionalModifiers) {
            temperature = modifier.modify(level, pos, temperature);
        }
        return temperature;
    }

    @Override
    public ITemperature getPlayerTemperature(Player player) {
        return ((ITANPlayer)player).getTemperatureData();
    }

    @Override
    public boolean isTemperatureEnabled() {
        return ModConfig.temperature.enableTemperature;
    }

    @Override
    public void setTicksHyperthermic(Player player, int ticks) {
        this.getPlayerTemperature(player).setHyperthermiaTicks(ticks);
    }

    @Override
    public float getPercentHyperthermic(Player player) {
        int i = this.getTicksRequiredForHyperthermia();
        return (float)Math.min(this.getTicksHyperthermic(player), i) / (float)i;
    }

    @Override
    public boolean isFullyHyperthermic(Player player) {
        return this.getTicksHyperthermic(player) >= this.getTicksRequiredForHyperthermia();
    }

    @Override
    public int getTicksRequiredForHyperthermia() {
        return 140;
    }

    @Override
    public int getTicksHyperthermic(Player player) {
        return this.getPlayerTemperature(player).getHyperthermiaTicks();
    }

    @Override
    public boolean isHeating(BlockState state) {
        return state.is(ModTags.Blocks.HEATING_BLOCKS) && (state.hasProperty((Property)BlockStateProperties.LIT) ? (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false : (state.hasProperty((Property)BlockStateProperties.POWERED) ? (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != false : (state.hasProperty((Property)BlockStateProperties.ENABLED) ? (Boolean)state.getValue((Property)BlockStateProperties.ENABLED) != false : (state.hasProperty((Property)BooleanProperty.create((String)"active")) ? (Boolean)state.getValue((Property)BooleanProperty.create((String)"active")) != false : !state.hasProperty((Property)BooleanProperty.create((String)"on")) || (Boolean)state.getValue((Property)BooleanProperty.create((String)"on")) != false))));
    }

    @Override
    public boolean isCooling(BlockState state) {
        return state.is(ModTags.Blocks.COOLING_BLOCKS) && (state.hasProperty((Property)BlockStateProperties.LIT) ? (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false : (state.hasProperty((Property)BlockStateProperties.POWERED) ? (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != false : (state.hasProperty((Property)BlockStateProperties.ENABLED) ? (Boolean)state.getValue((Property)BlockStateProperties.ENABLED) != false : (state.hasProperty((Property)BooleanProperty.create((String)"active")) ? (Boolean)state.getValue((Property)BooleanProperty.create((String)"active")) != false : !state.hasProperty((Property)BooleanProperty.create((String)"on")) || (Boolean)state.getValue((Property)BooleanProperty.create((String)"on")) != false))));
    }

    @Override
    public void registerPlayerTemperatureModifier(IPlayerTemperatureModifier modifier) {
        playerModifiers.add(modifier);
    }

    @Override
    public void registerPositionalTemperatureModifier(IPositionalTemperatureModifier modifier) {
        positionalModifiers.add(modifier);
    }

    @Override
    public void registerProximityBlockModifier(IProximityBlockModifier modifier) {
        proximityModifiers.add(modifier);
    }

    private static TemperatureLevel getBiomeTemperatureLevel(Level level, BlockPos pos) {
        Holder biome = level.getBiome(pos);
        float biomeTemperature = ((Biome)biome.value()).getBaseTemperature();
        if (!level.dimensionType().natural() || pos.getY() > ModConfig.temperature.environmentalModifierAltitude || pos.getY() >= level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).below().getY()) {
            if (biome.is(ModTags.Biomes.ICY_BIOMES)) {
                return TemperatureLevel.ICY;
            }
            if (biome.is(ModTags.Biomes.COLD_BIOMES)) {
                return TemperatureLevel.COLD;
            }
            if (biome.is(ModTags.Biomes.NEUTRAL_BIOMES)) {
                return TemperatureLevel.NEUTRAL;
            }
            if (biome.is(ModTags.Biomes.WARM_BIOMES)) {
                return TemperatureLevel.WARM;
            }
            if (biome.is(ModTags.Biomes.HOT_BIOMES)) {
                return TemperatureLevel.HOT;
            }
            if (biomeTemperature < 0.15f) {
                return TemperatureLevel.ICY;
            }
            if (biomeTemperature >= 0.15f && biomeTemperature < 0.45f) {
                return TemperatureLevel.COLD;
            }
            if (biomeTemperature >= 0.45f && biomeTemperature < 0.85f) {
                return TemperatureLevel.NEUTRAL;
            }
            if (biomeTemperature >= 0.85f && biomeTemperature < 1.0f) {
                return TemperatureLevel.WARM;
            }
            if (biomeTemperature >= 1.0f) {
                return TemperatureLevel.HOT;
            }
        }
        return TemperatureLevel.NEUTRAL;
    }

    private static TemperatureLevel altitudeModifier(Level level, BlockPos pos, TemperatureLevel current) {
        if (!level.dimensionType().natural()) {
            return current;
        }
        if (pos.getY() > ModConfig.temperature.temperatureDropAltitude) {
            current = current.decrement(1);
        } else if (pos.getY() < ModConfig.temperature.temperatureRiseAltitude) {
            current = current.increment(1);
        }
        return current;
    }

    private static TemperatureLevel rainModifier(Level level, BlockPos pos, TemperatureLevel current) {
        Holder biome = level.getBiome(pos);
        if (TemperatureHelperImpl.isExposedToRain(level, pos)) {
            current = TemperatureHelperImpl.coldEnoughToSnow(level, (Holder<Biome>)biome, pos) ? current.increment(ModConfig.temperature.snowTemperatureChange) : current.increment(ModConfig.temperature.wetTemperatureChange);
        }
        return current;
    }

    private static TemperatureLevel nightModifier(Level level, BlockPos pos, TemperatureLevel current) {
        boolean isNight;
        float time = level.getTimeOfDay(1.0f);
        boolean bl = isNight = time >= 0.25f && time <= 0.75f;
        if (level.dimensionType().natural() && isNight && (pos.getY() > ModConfig.temperature.environmentalModifierAltitude || pos.getY() >= level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).below().getY())) {
            if (current == TemperatureLevel.HOT) {
                current = current.increment(ModConfig.temperature.nightHotTemperatureChange);
            } else if (current != TemperatureLevel.NEUTRAL) {
                current = current.increment(ModConfig.temperature.nightTemperatureChange);
            }
        }
        return current;
    }

    private static TemperatureLevel proximityModifier(Level level, BlockPos pos, TemperatureLevel current) {
        HashSet heating = Sets.newHashSet();
        HashSet cooling = Sets.newHashSet();
        if (!level.isEmptyBlock(pos)) {
            pos = pos.above();
        }
        AreaFill.fill(level, pos, (checkerLevel, checkedPos) -> TemperatureHelperImpl.addHeatingOrCooling(heating, cooling, checkerLevel, checkedPos.pos()));
        if (heating.size() > cooling.size()) {
            current = current.increment(1);
        } else if (cooling.size() > heating.size()) {
            current = current.decrement(1);
        }
        return current;
    }

    private static void addHeatingOrCooling(Set<BlockPos> heating, Set<BlockPos> cooling, Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (TemperatureHelper.isHeatingBlock(state)) {
            heating.add(pos);
        } else if (TemperatureHelper.isCoolingBlock(state)) {
            cooling.add(pos);
        } else {
            for (IProximityBlockModifier modifier : proximityModifiers) {
                IProximityBlockModifier.Type sourceType = modifier.getProximityType(level, pos, state);
                if (sourceType == IProximityBlockModifier.Type.HEATING) {
                    heating.add(pos);
                    continue;
                }
                if (sourceType != IProximityBlockModifier.Type.COOLING) continue;
                cooling.add(pos);
            }
        }
    }

    private static TemperatureLevel thermoregulatorModifier(Player player, TemperatureLevel current) {
        return TemperatureHelperImpl.modifyTemperatureByThermoregulators(player.level(), TemperatureHelper.getTemperatureData(player).getNearbyThermoregulators(), player.blockPosition(), current);
    }

    private static TemperatureLevel immersionModifier(Player player, TemperatureLevel current) {
        Level level = player.level();
        BlockPos pos = player.blockPosition();
        ITemperature temperature = TemperatureHelper.getTemperatureData(player);
        if (player.isOnFire()) {
            current = current.increment(ModConfig.temperature.onFireTemperatureChange);
        }
        if (player.isInPowderSnow) {
            current = current.increment(ModConfig.temperature.powderSnowTemperatureChange);
        }
        if (TemperatureHelperImpl.isExposedToRain(level, pos)) {
            temperature.setDryTicks(0);
        } else if (!(player.getRootVehicle() instanceof Boat) && (player.isInWater() || level.getFluidState(pos).is(FluidTags.WATER))) {
            temperature.setDryTicks(0);
            current = current.increment(ModConfig.temperature.wetTemperatureChange);
        } else if (temperature.getDryTicks() < ModConfig.temperature.wetTicks) {
            current.increment(ModConfig.temperature.wetTemperatureChange);
        }
        return current;
    }

    protected static TemperatureLevel handheldModifier(Player player, TemperatureLevel current) {
        AtomicInteger coolingItems = new AtomicInteger();
        AtomicInteger heatingItems = new AtomicInteger();
        for (EquipmentSlot slot : EquipmentSlotGroup.HAND) {
            ItemStack stack = player.getItemBySlot(slot);
            if (stack.is(ModTags.Items.COOLING_HELD_ITEMS)) {
                coolingItems.getAndIncrement();
            }
            if (!stack.is(ModTags.Items.HEATING_HELD_ITEMS)) continue;
            heatingItems.getAndIncrement();
        }
        return current.increment(heatingItems.get() - coolingItems.get());
    }

    protected static TemperatureLevel armorModifier(Player player, TemperatureLevel current) {
        AtomicInteger coolingPieces = new AtomicInteger();
        AtomicInteger heatingPieces = new AtomicInteger();
        for (EquipmentSlot slot : EquipmentSlotGroup.ARMOR) {
            ItemStack stack = player.getItemBySlot(slot);
            if (stack.is(ModTags.Items.COOLING_ARMOR) || stack.is(ModTags.Items.HEATING_ARMOR)) {
                if (stack.is(ModTags.Items.COOLING_ARMOR)) {
                    coolingPieces.getAndIncrement();
                }
                if (!stack.is(ModTags.Items.HEATING_ARMOR)) continue;
                heatingPieces.getAndIncrement();
                continue;
            }
            TrimMaterials.getFromIngredient((HolderLookup.Provider)player.level().registryAccess(), (ItemStack)stack).ifPresent(material -> {
                if (material.is(ModTags.Trims.COOLING_TRIMS)) {
                    coolingPieces.getAndIncrement();
                }
                if (material.is(ModTags.Trims.HEATING_TRIMS)) {
                    heatingPieces.getAndIncrement();
                }
            });
        }
        TemperatureLevel armorAdjTemp = current.increment(heatingPieces.get() / 2 - coolingPieces.get() / 2);
        current = armorAdjTemp == TemperatureLevel.HOT && current != TemperatureLevel.HOT ? armorAdjTemp.decrement(1) : (armorAdjTemp == TemperatureLevel.ICY && current != TemperatureLevel.ICY ? armorAdjTemp.increment(1) : armorAdjTemp);
        Registry enchantmentRegistry = player.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        if (EnchantmentHelper.getEnchantmentLevel((Holder)enchantmentRegistry.getOrThrow(TANEnchantments.THERMAL_TUNING), (LivingEntity)player) > 0) {
            current = TemperatureLevel.NEUTRAL;
        }
        return current;
    }

    protected static TemperatureLevel internalModifier(Player player, TemperatureLevel current) {
        TemperatureLevel newTemperature = current;
        if (player.hasEffect(TANEffects.INTERNAL_WARMTH)) {
            newTemperature = newTemperature.increment(1);
        }
        if (player.hasEffect(TANEffects.INTERNAL_CHILL)) {
            newTemperature = newTemperature.decrement(1);
        }
        current = newTemperature == TemperatureLevel.HOT && current != TemperatureLevel.HOT ? newTemperature.decrement(1) : (newTemperature == TemperatureLevel.ICY && current != TemperatureLevel.ICY ? newTemperature.increment(1) : newTemperature);
        return current;
    }

    private static boolean isExposedToRain(Level level, BlockPos pos) {
        return level.isRaining() && pos.getY() >= level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).below().getY();
    }

    private static boolean coldEnoughToSnow(Level level, Holder<Biome> biome, BlockPos pos) {
        return ((Biome)biome.value()).coldEnoughToSnow(pos, level.getSeaLevel());
    }

    public static TemperatureLevel modifyTemperatureByThermoregulators(Level level, Set<BlockPos> thermoregulators, BlockPos checkPos, TemperatureLevel current) {
        int coolingCount = 0;
        int heatingCount = 0;
        int neutralCount = 0;
        for (BlockPos pos : thermoregulators) {
            ThermoregulatorBlockEntity blockEntity = (ThermoregulatorBlockEntity)level.getBlockEntity(pos);
            if (blockEntity == null) continue;
            switch (blockEntity.getEffectAtPos(checkPos)) {
                case COOLING: {
                    ++coolingCount;
                    break;
                }
                case HEATING: {
                    ++heatingCount;
                    break;
                }
                case NEUTRALIZING: {
                    ++neutralCount;
                }
            }
        }
        if (coolingCount == 0 && heatingCount == 0 && neutralCount > 0) {
            return TemperatureLevel.NEUTRAL;
        }
        if (coolingCount > heatingCount) {
            return current.decrement(2);
        }
        if (heatingCount > coolingCount) {
            return current.increment(2);
        }
        return current;
    }
}

