/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.Potion;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.potion.TANPotions;
import toughasnails.potion.ThirstEffect;

public class ModPotions {
    public static void registerEffects(BiConsumer<ResourceLocation, MobEffect> func) {
        TANEffects.THIRST = ModPotions.registerEffect(func, "thirst", new ThirstEffect(MobEffectCategory.HARMFUL, 7789388));
        TANEffects.ICE_RESISTANCE = ModPotions.registerEffect(func, "ice_resistance", new MobEffect(MobEffectCategory.BENEFICIAL, 7842303));
        TANEffects.CLIMATE_CLEMENCY = ModPotions.registerEffect(func, "climate_clemency", new MobEffect(MobEffectCategory.BENEFICIAL, 0xB6B6B6));
        TANEffects.INTERNAL_WARMTH = ModPotions.registerEffect(func, "internal_warmth", new MobEffect(MobEffectCategory.BENEFICIAL, 16775897));
        TANEffects.INTERNAL_CHILL = ModPotions.registerEffect(func, "internal_chill", new MobEffect(MobEffectCategory.BENEFICIAL, 14810367));
    }

    public static void registerPotions(BiConsumer<ResourceLocation, Potion> func) {
        TANPotions.ICE_RESISTANCE = ModPotions.registerPotion(func, "ice_resistance", new Potion("ice_resistance", new MobEffectInstance[]{new MobEffectInstance(TANEffects.ICE_RESISTANCE, 3600)}));
        TANPotions.LONG_ICE_RESISTANCE = ModPotions.registerPotion(func, "long_ice_resistance", new Potion("long_ice_resistance", new MobEffectInstance[]{new MobEffectInstance(TANEffects.ICE_RESISTANCE, 9600)}));
    }

    private static Holder<MobEffect> registerEffect(BiConsumer<ResourceLocation, MobEffect> func, String name, MobEffect effect) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"toughasnails", (String)name);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)location);
        func.accept(location, effect);
        return (Holder)BuiltInRegistries.MOB_EFFECT.get(key).orElseThrow();
    }

    private static Holder<Potion> registerPotion(BiConsumer<ResourceLocation, Potion> func, String name, Potion potion) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"toughasnails", (String)name);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.POTION, (ResourceLocation)location);
        func.accept(location, potion);
        return (Holder)BuiltInRegistries.POTION.get(key).orElseThrow();
    }
}

