/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.client.handler;

import glitchcore.event.client.LevelRenderEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import org.joml.Matrix4f;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.block.entity.ThermoregulatorBlockEntity;
import toughasnails.temperature.AreaFill;

public class LevelRenderHandler {
    public static boolean enableDebug = false;
    private static final Set<ConnectedBlock> connectedBlocks = new HashSet<ConnectedBlock>();

    public static void onLevelRender(LevelRenderEvent event) {
        class_746 player = class_310.method_1551().field_1724;
        if (!enableDebug || player == null) {
            return;
        }
        class_243 cameraPos = event.getCamera().field_63078;
        class_4587 poseStack = event.getPoseStack();
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        class_4588 vertexConsumer = bufferSource.method_73477(class_1921.method_23594());
        poseStack.method_22903();
        poseStack.method_22904(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215());
        LevelRenderHandler.getConnectedBlocks((class_1657)player).forEach(block -> block.render(poseStack, vertexConsumer));
        poseStack.method_22909();
    }

    private static Set<ConnectedBlock> getConnectedBlocks(class_1657 player) {
        class_1937 level = player.method_73183();
        connectedBlocks.clear();
        LevelRenderHandler.populateConnectedBlocks(player);
        return connectedBlocks;
    }

    private static void populateConnectedBlocks(class_1657 player) {
        class_2338 playerPos;
        class_1937 level = player.method_73183();
        if (!level.method_22347(playerPos = player.method_24515())) {
            playerPos = playerPos.method_10084();
        }
        final HashSet<class_2338> passablePositions = new HashSet<class_2338>();
        final HashSet<class_2338> heatingPositions = new HashSet<class_2338>();
        final HashSet<class_2338> coolingPositions = new HashSet<class_2338>();
        HashSet<class_2338> thermoregulatorPositions = new HashSet<class_2338>();
        final HashSet<class_2338> blockingPositions = new HashSet<class_2338>();
        AreaFill.fill(level, playerPos, new AreaFill.PositionChecker(){

            @Override
            public void onSolid(class_1937 level, AreaFill.FillPos pos) {
                class_2680 state = level.method_8320(pos.pos());
                if (TemperatureHelper.isHeatingBlock(state)) {
                    heatingPositions.add(pos.pos());
                } else if (TemperatureHelper.isCoolingBlock(state)) {
                    coolingPositions.add(pos.pos());
                } else {
                    blockingPositions.add(pos.pos());
                }
            }

            @Override
            public void onPassable(class_1937 level, AreaFill.FillPos pos) {
                passablePositions.add(pos.pos());
            }
        });
        for (class_2338 pos : TemperatureHelper.getTemperatureData(player).getNearbyThermoregulators()) {
            ThermoregulatorBlockEntity blockEntity = (ThermoregulatorBlockEntity)level.method_8321(pos);
            if (blockEntity == null) continue;
            thermoregulatorPositions.addAll((Collection<class_2338>)blockEntity.getFilledBlocks());
        }
        LevelRenderHandler.connectBlocks(passablePositions, 170, 170, 170, 255);
        LevelRenderHandler.connectBlocks(heatingPositions, 255, 170, 0, 255);
        LevelRenderHandler.connectBlocks(coolingPositions, 85, 255, 255, 255);
        LevelRenderHandler.connectBlocks(thermoregulatorPositions, 255, 85, 255, 255);
        LevelRenderHandler.connectBlocks(blockingPositions, 255, 85, 85, 255);
    }

    private static void connectBlocks(Set<class_2338> positions, int r, int g, int b, int a) {
        for (class_2338 pos : positions) {
            HashSet<class_2350> connectedFaces = new HashSet<class_2350>();
            for (class_2350 dir : class_2350.values()) {
                if (!positions.contains(pos.method_10093(dir))) continue;
                connectedFaces.add(dir);
            }
            if (connectedFaces.containsAll(Arrays.stream(class_2350.values()).toList())) continue;
            connectedBlocks.add(new ConnectedBlock(pos, connectedFaces, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f));
        }
    }

    private static class ConnectedBlock {
        private final class_2338 pos;
        private final Set<class_2350> connectedFaces;
        private final float r;
        private final float g;
        private final float b;
        private final float a;
        private final float minX;
        private final float minY;
        private final float minZ;
        private final float maxX;
        private final float maxY;
        private final float maxZ;

        private ConnectedBlock(class_2338 pos, Set<class_2350> connectedFaces, float r, float g, float b, float a) {
            this.pos = pos;
            this.connectedFaces = connectedFaces;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.minX = (float)pos.method_10263() + 1.0E-4f;
            this.minY = (float)pos.method_10264() + 1.0E-4f;
            this.minZ = (float)pos.method_10260() + 1.0E-4f;
            this.maxX = (float)pos.method_10263() + 1.0f - 1.0E-4f;
            this.maxY = (float)pos.method_10264() + 1.0f - 1.0E-4f;
            this.maxZ = (float)pos.method_10260() + 1.0f - 1.0E-4f;
        }

        public void render(class_4587 poseStack, class_4588 vertexConsumer) {
            Matrix4f poseMatrix = poseStack.method_23760().method_23761();
            class_4587.class_4665 lastPose = poseStack.method_23760();
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.minX, this.minY, this.minZ, this.maxX, this.minY, this.minZ, class_2350.field_11043, class_2350.field_11033);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.minX, this.minY, this.minZ, this.minX, this.maxY, this.minZ, class_2350.field_11043, class_2350.field_11039);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.maxX, this.minY, this.minZ, this.maxX, this.maxY, this.minZ, class_2350.field_11043, class_2350.field_11034);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.maxX, this.maxY, this.minZ, this.minX, this.maxY, this.minZ, class_2350.field_11043, class_2350.field_11036);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.minX, this.maxY, this.maxZ, this.minX, this.minY, this.maxZ, class_2350.field_11035, class_2350.field_11039);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.minX, this.minY, this.maxZ, this.maxX, this.minY, this.maxZ, class_2350.field_11035, class_2350.field_11033);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.minX, this.maxY, this.maxZ, this.maxX, this.maxY, this.maxZ, class_2350.field_11035, class_2350.field_11036);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.maxX, this.minY, this.maxZ, this.maxX, this.maxY, this.maxZ, class_2350.field_11035, class_2350.field_11034);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.minX, this.minY, this.minZ, this.minX, this.minY, this.maxZ, class_2350.field_11039, class_2350.field_11033);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.minX, this.maxY, this.minZ, this.minX, this.maxY, this.maxZ, class_2350.field_11039, class_2350.field_11036);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.maxX, this.minY, this.maxZ, this.maxX, this.minY, this.minZ, class_2350.field_11034, class_2350.field_11033);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.maxX, this.maxY, this.minZ, this.maxX, this.maxY, this.maxZ, class_2350.field_11034, class_2350.field_11036);
        }

        public Set<class_2350> getConnectedFaces() {
            return this.connectedFaces;
        }

        private void drawLine(class_4588 vertexConsumer, Matrix4f poseMatrix, class_4587.class_4665 lastPose, float fromX, float fromY, float fromZ, float toX, float toY, float toZ, class_2350 ... relevantFaces) {
            if (Arrays.stream(relevantFaces).anyMatch(this.connectedFaces::contains)) {
                return;
            }
            float normalX = Math.signum(fromX - toX);
            float normalY = Math.signum(fromY - toY);
            float normalZ = Math.signum(fromZ - toZ);
            vertexConsumer.method_22918(poseMatrix, fromX, fromY, fromZ).method_22915(this.r, this.g, this.b, this.a).method_60831(lastPose, normalX, normalY, normalZ);
            vertexConsumer.method_22918(poseMatrix, toX, toY, toZ).method_22915(this.r, this.g, this.b, this.a).method_60831(lastPose, normalX, normalY, normalZ);
        }
    }
}

