/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.client.item;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_11566;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1800;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.temperature.TemperatureHelperImpl;

public class TemperatureProperty
implements class_1800 {
    public static final MapCodec<TemperatureProperty> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.unboundedMap((Codec)Codec.INT, Delta.CODEC).fieldOf("deltas").forGetter(TemperatureProperty::deltas)).apply((Applicative)builder, TemperatureProperty::new));
    private final Map<Integer, Delta> deltas;

    public TemperatureProperty(Map<Integer, Delta> deltas) {
        this.deltas = Maps.newHashMap(deltas);
    }

    public TemperatureProperty() {
        this.deltas = new HashMap<Integer, Delta>();
    }

    public float method_65644(class_1799 stack, @Nullable class_638 level, @Nullable class_11566 owner, int i) {
        class_1297 holder = (class_1297)(owner != null ? owner : stack.method_27319());
        if (owner == null) {
            return 0.5f;
        }
        if (level == null && owner.method_73183() instanceof class_638) {
            level = (class_638)holder.method_73183();
        }
        if (level == null) {
            return 0.5f;
        }
        Delta delta = this.deltas.computeIfAbsent(holder.method_5628(), k -> new Delta());
        delta.update(level, TemperatureProperty.getTemperatureForThermometer((class_1937)level, holder));
        return delta.getValue();
    }

    public MapCodec<? extends class_1800> method_65643() {
        return CODEC;
    }

    private Map<Integer, Delta> deltas() {
        return this.deltas;
    }

    private static TemperatureLevel getTemperatureForThermometer(class_1937 level, class_1297 holder) {
        TemperatureLevel temperatureLevel = TemperatureHelper.getTemperatureAtPos(level, holder.method_24515());
        class_746 player = class_310.method_1551().field_1724;
        Set<class_2338> nearbyThermoregulators = TemperatureHelper.getTemperatureData((class_1657)player).getNearbyThermoregulators();
        return TemperatureHelperImpl.modifyTemperatureByThermoregulators(level, nearbyThermoregulators, holder.method_24515(), temperatureLevel);
    }

    private static class Delta {
        public static final Codec<Delta> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.LONG.fieldOf("last_update_tick").forGetter(Delta::lastUpdateTick), (App)Codec.DOUBLE.fieldOf("value").forGetter(Delta::currentValue), (App)Codec.DOUBLE.fieldOf("rota").forGetter(Delta::rota)).apply((Applicative)builder, Delta::new));
        private long lastUpdateTick;
        private double currentValue;
        private double rota;

        public Delta(long lastUpdateTick, double currentValue, double rota) {
            this.lastUpdateTick = lastUpdateTick;
            this.currentValue = currentValue;
            this.rota = rota;
        }

        public Delta() {
        }

        private void update(class_638 level, TemperatureLevel temperatureLevel) {
            if (level.method_8510() == this.lastUpdateTick) {
                return;
            }
            this.lastUpdateTick = level.method_8510();
            double targetValue = (double)temperatureLevel.ordinal() * 0.25;
            double delta = targetValue - this.currentValue;
            this.rota += delta * 0.1;
            this.rota *= 0.87;
            this.currentValue = class_3532.method_15350((double)(this.currentValue + this.rota), (double)0.0, (double)1.0);
        }

        public float getValue() {
            return (float)((double)Math.round(this.currentValue * 20.0) / 20.0);
        }

        private long lastUpdateTick() {
            return this.lastUpdateTick;
        }

        private double currentValue() {
            return this.currentValue;
        }

        private double rota() {
            return this.rota;
        }
    }
}

