/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import toughasnails.api.thirst.ThirstHelper;

public abstract class DrinkItem
extends Item {
    public DrinkItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        Player player;
        Player player2 = player = entityLiving instanceof Player ? (Player)entityLiving : null;
        if (player == null) {
            return stack;
        }
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, stack);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
            if (stack.isEmpty()) {
                return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            }
            player.getInventory().add(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
        }
        return stack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.DRINK;
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        if (ThirstHelper.canDrink(player, this.canAlwaysDrink())) {
            return ItemUtils.startUsingInstantly((Level)world, (Player)player, (InteractionHand)hand);
        }
        return InteractionResult.FAIL;
    }

    public abstract boolean canAlwaysDrink();
}

