/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import glitchcore.util.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModTags;
import sereneseasons.season.SeasonHooks;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.core.ToughAsNails;
import toughasnails.init.ModConfig;

public class ModCompatibility {
    public static void init() {
        if (Environment.isModLoaded((String)"sereneseasons")) {
            ToughAsNails.LOGGER.info("Serene Seasons detected. Enabling season modifier.");
            TemperatureHelper.registerPositionalTemperatureModifier(ModCompatibility::seasonModifier);
        }
    }

    public static boolean coldEnoughToSnowSeasonal(Level level, Holder<Biome> biome, BlockPos pos) {
        return SeasonHooks.coldEnoughToSnowSeasonal((LevelReader)level, (BlockPos)pos, (int)level.getSeaLevel());
    }

    private static TemperatureLevel seasonModifier(Level level, BlockPos pos, TemperatureLevel current) {
        Holder biome = level.getBiome(pos);
        if (level.dimensionType().natural() && pos.getY() <= ModConfig.temperature.environmentalModifierAltitude && pos.getY() < level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).below().getY()) {
            return current;
        }
        if (biome.is(ModTags.Biomes.BLACKLISTED_BIOMES)) {
            return current;
        }
        Season.TropicalSeason tropicalSeason = SeasonHelper.getSeasonState((Level)level).getTropicalSeason();
        if (biome.is(ModTags.Biomes.TROPICAL_BIOMES)) {
            switch (tropicalSeason) {
                case MID_DRY: {
                    current = current.increment(1);
                    break;
                }
                case MID_WET: {
                    if (current != TemperatureLevel.HOT) break;
                    current = current.decrement(1);
                }
            }
            return current;
        }
        Season season = SeasonHelper.getSeasonState((Level)level).getSeason();
        switch (season) {
            case SUMMER: {
                current = current.increment(1);
                break;
            }
            case WINTER: {
                current = current.decrement(1);
            }
        }
        return current;
    }
}

