/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.bl_accessories_layer.neoforge.compat.accessories;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.oxcodsnet.bl_accessories_layer.common.compat.accessories.AccessoriesRendererReloadScheduler;

public final class AccessoriesRendererReloadHandler {
    private static final AtomicBoolean REGISTERED = new AtomicBoolean();

    private AccessoriesRendererReloadHandler() {
    }

    public static void register(Runnable action) {
        AccessoriesRendererReloadScheduler.setReloadAction(action);
        if (REGISTERED.compareAndSet(false, true)) {
            NeoForge.EVENT_BUS.addListener(AccessoriesRendererReloadHandler::onClientTick);
            ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
            if (resourceManager instanceof ReloadableResourceManager) {
                ReloadableResourceManager reloadable = (ReloadableResourceManager)resourceManager;
                reloadable.registerReloadListener(AccessoriesRendererReloadHandler.createListener());
            }
        } else {
            AccessoriesRendererReloadScheduler.requestReload();
        }
    }

    private static PreparableReloadListener createListener() {
        return new SimplePreparableReloadListener<Void>(){

            protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
                return null;
            }

            protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
                AccessoriesRendererReloadScheduler.requestReload();
            }
        };
    }

    private static void onClientTick(ClientTickEvent.Post event) {
        AccessoriesRendererReloadScheduler.runIfReady();
    }
}

