/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.bl_accessories_layer.common.compat.accessories;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.oxcodsnet.beltborne_lanterns.BLMod;

public abstract class AbstractAccessoriesCompat<P, S> {
    protected static final String BELT = "belt";
    private final Set<UUID> syncing = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<UUID, S> pendingRespawn = new ConcurrentHashMap<UUID, S>();
    private final String platformName;

    protected AbstractAccessoriesCompat(String platformName) {
        this.platformName = platformName;
    }

    public final String modIdImpl() {
        return "accessories";
    }

    public final void initializeImpl() {
        this.registerEvents();
        BLMod.LOGGER.info("Accessories integration active [{}]", (Object)this.platformName);
    }

    protected abstract void registerEvents();

    protected final void handleSlotChange(P player, SlotAccess<S> reference, S previous, S current) {
        if (player == null) {
            return;
        }
        if (!reference.isValid()) {
            return;
        }
        if (!this.isBeltSlot(reference)) {
            return;
        }
        boolean prevIsLamp = this.isLamp(previous);
        boolean newIsLamp = this.isLamp(current);
        UUID playerId = this.getPlayerId(player);
        if (!prevIsLamp && newIsLamp) {
            if (this.hasMirroredLamp(player) && !this.syncing.contains(playerId)) {
                boolean same;
                S existing = this.getMirroredStack(player);
                boolean bl = same = existing != null && this.stacksEqual(existing, current);
                if (!(same || this.isCreative(player) || existing == null || this.isEmpty(existing))) {
                    this.giveBack(player, this.copyStack(existing));
                }
            }
            this.setMirroredLamp(player, this.copyStack(current));
            this.broadcast(player, current);
        } else if (prevIsLamp && !newIsLamp) {
            this.setMirroredLamp(player, null);
            this.broadcast(player, null);
        } else if (prevIsLamp && newIsLamp) {
            this.setMirroredLamp(player, this.copyStack(current));
            this.broadcast(player, current);
        }
    }

    protected final void handleClone(P oldPlayer, P newPlayer) {
        if (!this.hasMirroredLamp(oldPlayer)) {
            return;
        }
        Optional<S> slotStack = this.getBeltStackImpl(newPlayer);
        if (slotStack.isEmpty()) {
            return;
        }
        S stack = slotStack.get();
        if (!this.isLamp(stack)) {
            return;
        }
        this.pendingRespawn.put(this.getPlayerId(newPlayer), this.copyStack(stack));
        this.setMirroredLamp(oldPlayer, null);
    }

    protected final void handleRespawn(P player) {
        S pending = this.pendingRespawn.remove(this.getPlayerId(player));
        if (pending == null || this.isEmpty(pending)) {
            return;
        }
        this.setMirroredLamp(player, pending);
        this.broadcast(player, pending);
    }

    public final boolean tryToggleLanternImpl(P player) {
        SlotAccess<S> reference = this.createSlotAccess(player);
        if (!reference.isValid()) {
            return false;
        }
        S stack = reference.getStack();
        if (!this.isLamp(stack)) {
            return false;
        }
        S toReturn = this.copyStack(stack);
        reference.setStack(this.emptyStack());
        if (!this.isCreative(player) && !this.isEmpty(toReturn)) {
            this.giveBack(player, toReturn);
        }
        return true;
    }

    public final Optional<S> getBeltStackImpl(P player) {
        SlotAccess<S> reference = this.createSlotAccess(player);
        if (!reference.isValid()) {
            return Optional.empty();
        }
        if (!this.isBeltSlot(reference)) {
            return Optional.empty();
        }
        return Optional.of(reference.getStack());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void syncToggleOnImpl(P player) {
        SlotAccess<S> reference = this.createSlotAccess(player);
        if (!reference.isValid()) {
            return;
        }
        if (!this.isEmpty(reference.getStack())) {
            return;
        }
        S stored = this.getMirroredStack(player);
        if (stored == null || this.isEmpty(stored)) {
            return;
        }
        UUID playerId = this.getPlayerId(player);
        this.syncing.add(playerId);
        try {
            reference.setStack(this.copyStack(stored));
        }
        finally {
            this.syncing.remove(playerId);
        }
    }

    protected final boolean isBeltSlot(SlotAccess<S> reference) {
        String name = reference.slotName();
        return BELT.equals(name) || name != null && name.endsWith(":belt");
    }

    protected abstract SlotAccess<S> createSlotAccess(P var1);

    protected abstract boolean hasMirroredLamp(P var1);

    protected abstract S getMirroredStack(P var1);

    protected abstract void setMirroredLamp(P var1, S var2);

    protected abstract boolean isCreative(P var1);

    protected abstract void giveBack(P var1, S var2);

    protected abstract void broadcast(P var1, S var2);

    protected abstract boolean isLamp(S var1);

    protected abstract boolean isEmpty(S var1);

    protected abstract S copyStack(S var1);

    protected abstract S emptyStack();

    protected abstract boolean stacksEqual(S var1, S var2);

    protected abstract UUID getPlayerId(P var1);

    protected static interface SlotAccess<S> {
        public boolean isValid();

        public String slotName();

        public S getStack();

        public void setStack(S var1);
    }
}

