/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.bl_accessories_layer.neoforge.compat.accessories;

import io.wispforest.accessories.api.events.AccessoryChangeCallback;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.oxcodsnet.beltborne_lanterns.common.BeltState;
import net.oxcodsnet.beltborne_lanterns.common.LampRegistry;
import net.oxcodsnet.beltborne_lanterns.common.compat.CompatibilityLayer;
import net.oxcodsnet.beltborne_lanterns.common.persistence.BeltLanternSave;
import net.oxcodsnet.beltborne_lanterns.neoforge.BeltNetworking;
import net.oxcodsnet.bl_accessories_layer.common.compat.accessories.AbstractAccessoriesCompat;

public final class AccessoriesCompatNeoForge
extends AbstractAccessoriesCompat<ServerPlayer, ItemStack>
implements CompatibilityLayer {
    public AccessoriesCompatNeoForge() {
        super("NeoForge");
    }

    public String getModId() {
        return this.modIdImpl();
    }

    public void onInitialize() {
        this.initializeImpl();
    }

    public boolean tryToggleLantern(ServerPlayer player) {
        return this.tryToggleLanternImpl(player);
    }

    public Optional<ItemStack> getBeltStack(ServerPlayer player) {
        return this.getBeltStackImpl(player);
    }

    public void syncToggleOn(ServerPlayer player) {
        this.syncToggleOnImpl(player);
    }

    @Override
    protected void registerEvents() {
        this.registerAccessoryCallbacks();
        this.registerRespawnCallbacks();
    }

    private void registerAccessoryCallbacks() {
        AccessoryChangeCallback.EVENT.register((previous, current, reference, change) -> {
            LivingEntity patt0$temp = reference.entity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            this.handleSlotChange(player, this.wrap(reference), previous, current);
        });
    }

    private void registerRespawnCallbacks() {
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this::onClone);
        NeoForge.EVENT_BUS.addListener(this::onRespawn);
    }

    private void onClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player player = event.getOriginal();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer oldPlayer = (ServerPlayer)player;
        Player player2 = event.getEntity();
        if (!(player2 instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer newPlayer = (ServerPlayer)player2;
        this.handleClone(oldPlayer, newPlayer);
    }

    private void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        this.handleRespawn(player2);
    }

    @Override
    protected AbstractAccessoriesCompat.SlotAccess<ItemStack> createSlotAccess(ServerPlayer player) {
        return new SlotReferenceAccess(SlotReference.of((LivingEntity)player, (String)"belt", (int)0));
    }

    @Override
    protected boolean hasMirroredLamp(ServerPlayer player) {
        return BeltState.hasLamp((Player)player);
    }

    @Override
    protected ItemStack getMirroredStack(ServerPlayer player) {
        return BeltState.getLampStack((Player)player);
    }

    @Override
    protected void setMirroredLamp(ServerPlayer player, ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            BeltState.setLamp((Player)player, (ItemStack)null);
            BeltLanternSave.get((MinecraftServer)player.server).set(player.getUUID(), (ItemStack)null);
        } else {
            BeltState.setLamp((Player)player, (ItemStack)stack);
            BeltLanternSave.get((MinecraftServer)player.server).set(player.getUUID(), stack);
        }
    }

    @Override
    protected boolean isCreative(ServerPlayer player) {
        return player.isCreative();
    }

    @Override
    protected void giveBack(ServerPlayer player, ItemStack stack) {
        player.addItem(stack);
    }

    @Override
    protected void broadcast(ServerPlayer player, ItemStack stack) {
        BeltNetworking.broadcastBeltState((ServerPlayer)player, stack == null || stack.isEmpty() ? null : stack.getItem());
    }

    @Override
    protected boolean isLamp(ItemStack stack) {
        return stack != null && LampRegistry.isLamp((ItemStack)stack);
    }

    @Override
    protected boolean isEmpty(ItemStack stack) {
        return stack == null || stack.isEmpty();
    }

    @Override
    protected ItemStack copyStack(ItemStack stack) {
        return stack == null ? ItemStack.EMPTY : stack.copy();
    }

    @Override
    protected ItemStack emptyStack() {
        return ItemStack.EMPTY;
    }

    @Override
    protected boolean stacksEqual(ItemStack first, ItemStack second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)first, (ItemStack)second);
    }

    @Override
    protected UUID getPlayerId(ServerPlayer player) {
        return player.getUUID();
    }

    private AbstractAccessoriesCompat.SlotAccess<ItemStack> wrap(SlotReference reference) {
        return new SlotReferenceAccess(reference);
    }

    private static final class SlotReferenceAccess
    implements AbstractAccessoriesCompat.SlotAccess<ItemStack> {
        private final SlotReference delegate;

        private SlotReferenceAccess(SlotReference delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isValid() {
            return this.delegate != null && this.delegate.isValid();
        }

        @Override
        public String slotName() {
            return this.delegate.slotName();
        }

        @Override
        public ItemStack getStack() {
            return this.delegate.getStack();
        }

        @Override
        public void setStack(ItemStack stack) {
            this.delegate.setStack(stack);
        }
    }
}

