/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.bl_accessories_layer.neoforge.compat.accessories;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;

public final class AccessoriesRendererReloadHandler {
    private static final AtomicBoolean REGISTERED = new AtomicBoolean();
    private static final AtomicBoolean PENDING_RELOAD = new AtomicBoolean();
    private static Runnable reloadAction;

    private AccessoriesRendererReloadHandler() {
    }

    public static void register(Runnable action) {
        reloadAction = action;
        if (REGISTERED.compareAndSet(false, true)) {
            PENDING_RELOAD.set(true);
            NeoForge.EVENT_BUS.addListener(AccessoriesRendererReloadHandler::onClientTick);
            ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
            if (resourceManager instanceof ReloadableResourceManager) {
                ReloadableResourceManager reloadable = (ReloadableResourceManager)resourceManager;
                reloadable.registerReloadListener(AccessoriesRendererReloadHandler.createListener());
            }
        } else {
            PENDING_RELOAD.set(true);
        }
    }

    private static PreparableReloadListener createListener() {
        return new SimplePreparableReloadListener<Void>(){

            protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
                return null;
            }

            protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
                PENDING_RELOAD.set(true);
            }
        };
    }

    private static void onClientTick(ClientTickEvent.Post event) {
        if (PENDING_RELOAD.compareAndSet(true, false) && reloadAction != null) {
            reloadAction.run();
        }
    }
}

