/*
 * Decompiled with CFR 0.152.
 */
package xyz.dogboy.swp.event;

import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.dogboy.swp.Registry;
import xyz.dogboy.swp.Utils;
import xyz.dogboy.swp.blocks.BlockPipe;
import xyz.dogboy.swp.config.SWPConfig;
import xyz.dogboy.swp.items.ItemBlockWoodenVariation;
import xyz.dogboy.swp.tiles.TilePipe;
import xyz.dogboy.swp.tiles.TilePump;

@Mod.EventBusSubscriber(modid="simplewoodenpipes")
public class CommonEventHandler {
    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{Registry.PIPE, Registry.PUMP});
        GameRegistry.registerTileEntity(TilePipe.class, (ResourceLocation)Registry.PIPE.getRegistryName());
        GameRegistry.registerTileEntity(TilePump.class, (ResourceLocation)Registry.PUMP.getRegistryName());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{Registry.PIPE_ITEM, Registry.PUMP_ITEM});
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (!SWPConfig.addRecipes) {
            return;
        }
        Stream.concat(Utils.getAllPlanks().stream(), BlockPipe.stoneVariants.stream()).map(baseBlock -> {
            Ingredient baseBlockIngredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{baseBlock});
            OreIngredient glassIngredient = new OreIngredient("blockGlass");
            ItemStack output = ((ItemBlockWoodenVariation)Registry.PIPE_ITEM).getWithBaseBlock((ItemStack)baseBlock);
            output.func_190920_e(6);
            return CommonEventHandler.getRecipe(String.format("pipe_%s_%s_%d", baseBlock.func_77973_b().getRegistryName().func_110624_b(), baseBlock.func_77973_b().getRegistryName().func_110624_b(), baseBlock.func_77960_j()), output, new Ingredient[]{baseBlockIngredient, glassIngredient, baseBlockIngredient, baseBlockIngredient, glassIngredient, baseBlockIngredient, baseBlockIngredient, glassIngredient, baseBlockIngredient});
        }).forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
    }

    private static IRecipe getRecipe(String id, ItemStack output, Ingredient ... ingredients) {
        ShapedRecipes recipe = new ShapedRecipes("", 3, 3, NonNullList.func_193580_a((Object)ingredients[0], (Object[])ingredients), output);
        return (IRecipe)recipe.setRegistryName(new ResourceLocation("simplewoodenpipes", id));
    }
}

