/*
 * Decompiled with CFR 0.152.
 */
package xyz.dogboy.swp.tiles;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import xyz.dogboy.swp.Utils;
import xyz.dogboy.swp.blocks.BlockWoodenVariation;
import xyz.dogboy.swp.config.SWPConfig;
import xyz.dogboy.swp.tiles.PersistantSyncableTileEntity;
import xyz.dogboy.swp.tiles.TilePump;
import xyz.dogboy.swp.tiles.WoodenVariationProvider;

public class TilePipe
extends PersistantSyncableTileEntity
implements ITickable,
IFluidHandler,
WoodenVariationProvider {
    private Fluid fluid;
    private int amount;
    private boolean extraction;
    private ItemStack cachedBaseBlock;

    public void func_73660_a() {
        if (this.fluid != null && this.fluid.getTemperature() >= 550 && Utils.isBurnable(this.getBaseBlock())) {
            this.func_145831_w().func_175656_a(this.func_174877_v(), Blocks.field_150480_ab.func_176223_P());
            return;
        }
        for (EnumFacing facing : EnumFacing.values()) {
            IFluidHandler fluidHandler;
            BlockPos pos = this.func_174877_v().func_177972_a(facing);
            TileEntity tileEntity = this.func_145831_w().func_175625_s(pos);
            if (!this.canConnectTo(tileEntity, facing, false) || (fluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) == null) continue;
            boolean isPipe = tileEntity instanceof TilePipe;
            if (this.extraction && !isPipe) {
                FluidStack drainableFluid;
                int freeSpace;
                if (tileEntity instanceof TilePump || (freeSpace = SWPConfig.internalVolume - this.amount) <= 0) continue;
                FluidStack fluidStack = drainableFluid = this.fluid == null ? fluidHandler.drain(Math.min(SWPConfig.transferRate, freeSpace), true) : fluidHandler.drain(new FluidStack(this.fluid, Math.min(SWPConfig.transferRate, freeSpace)), true);
                if (drainableFluid == null || drainableFluid.amount <= 0) continue;
                this.amount += drainableFluid.amount;
                if (this.fluid != null) continue;
                this.fluid = drainableFluid.getFluid();
                continue;
            }
            if (this.fluid == null || this.amount <= 0 || isPipe && ((TilePipe)tileEntity).amount > this.amount) continue;
            this.amount -= fluidHandler.fill(new FluidStack(this.fluid, Math.min(SWPConfig.transferRate, this.amount)), true);
        }
    }

    private FluidStack getFluidStack() {
        if (this.amount <= 0) {
            return null;
        }
        return new FluidStack(this.fluid, this.amount);
    }

    public boolean isExtractionEnabled() {
        return this.extraction;
    }

    public void setExtractionEnabled(boolean extraction) {
        this.extraction = extraction;
        this.triggerUpdate();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this;
        }
        return null;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(this.getFluidStack(), SWPConfig.internalVolume)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        int maxFill;
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        FluidStack current = this.getFluidStack();
        int n = current == null ? Math.min(SWPConfig.internalVolume, resource.amount) : (maxFill = current.isFluidEqual(resource) ? Math.min(SWPConfig.internalVolume - current.amount, resource.amount) : 0);
        if (!doFill) {
            return maxFill;
        }
        if (current == null) {
            this.fluid = resource.getFluid();
            this.amount = resource.amount;
            this.triggerUpdate();
            return resource.amount;
        }
        if (current.isFluidEqual(resource)) {
            this.amount += maxFill;
            this.triggerUpdate();
            return maxFill;
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain <= 0) {
            return null;
        }
        FluidStack current = this.getFluidStack();
        if (current == null) {
            return null;
        }
        return this.drain(new FluidStack(current.getFluid(), maxDrain), doDrain);
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || resource.amount <= 0) {
            return null;
        }
        FluidStack current = this.getFluidStack();
        if (current == null) {
            return null;
        }
        int maxDrain = Math.min(SWPConfig.transferRate, Math.min(current.amount, resource.amount));
        if (!doDrain) {
            return new FluidStack(current.getFluid(), maxDrain);
        }
        this.amount -= maxDrain;
        this.triggerUpdate();
        return new FluidStack(current.getFluid(), maxDrain);
    }

    @Override
    protected void writeData(NBTTagCompound tagCompound) {
        FluidStack current = this.getFluidStack();
        if (current != null) {
            tagCompound.func_74778_a("FluidName", FluidRegistry.getFluidName((Fluid)current.getFluid()));
            tagCompound.func_74768_a("FluidAmount", current.amount);
        }
        tagCompound.func_74757_a("CanExtract", this.extraction);
    }

    @Override
    protected void readData(NBTTagCompound tagCompound) {
        if (tagCompound.func_74764_b("FluidName") && tagCompound.func_74764_b("FluidAmount")) {
            String fluidName = tagCompound.func_74779_i("FluidName");
            int fluidAmount = tagCompound.func_74762_e("FluidAmount");
            Fluid fluid = FluidRegistry.getFluid((String)fluidName);
            if (fluid == null) {
                return;
            }
            this.fluid = fluid;
            this.amount = fluidAmount;
        }
        this.extraction = tagCompound.func_74767_n("CanExtract");
    }

    public ItemStack getBaseBlock() {
        if (this.cachedBaseBlock == null) {
            if (!this.getTileData().func_74764_b("BaseBlock")) {
                return new ItemStack(Blocks.field_150350_a);
            }
            NBTTagCompound baseBlock = this.getTileData().func_74775_l("BaseBlock");
            this.cachedBaseBlock = new ItemStack(baseBlock);
        }
        return this.cachedBaseBlock;
    }

    @Override
    public IExtendedBlockState writeExtendedState(IExtendedBlockState state) {
        Block block;
        ItemStack stack;
        String texture = this.getTileData().func_74779_i("Texture");
        if (texture.isEmpty() && !(stack = this.getBaseBlock()).func_190926_b() && (block = Block.func_149634_a((Item)stack.func_77973_b())) != Blocks.field_150350_a) {
            texture = Utils.getTextureFromBlock(block, stack.func_77952_i());
            this.getTileData().func_74778_a("Texture", texture);
        }
        return state.withProperty((IUnlistedProperty)BlockWoodenVariation.TEXTURE, (Object)(texture.isEmpty() ? "minecraft:blocks/planks_oak" : texture));
    }

    public boolean canConnectTo(EnumFacing direction, boolean excludePipe) {
        return this.canConnectTo(this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(direction)), direction, excludePipe);
    }

    public boolean canConnectTo(TileEntity tileEntity, EnumFacing direction, boolean excludePipe) {
        if (tileEntity == null) {
            return false;
        }
        if (tileEntity instanceof TilePump) {
            return direction == EnumFacing.DOWN && !excludePipe;
        }
        if (tileEntity instanceof TilePipe) {
            if (excludePipe) {
                return false;
            }
            TilePipe otherPipe = (TilePipe)tileEntity;
            if (SWPConfig.variantInterconnection) {
                return Utils.isBurnable(otherPipe.getBaseBlock()) == Utils.isBurnable(this.getBaseBlock());
            }
            return otherPipe.getBaseBlock().func_77969_a(this.getBaseBlock());
        }
        return tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d());
    }
}

