/*
 * Decompiled with CFR 0.152.
 */
package xyz.dogboy.swp;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import xyz.dogboy.swp.config.CfgHandler;
import xyz.dogboy.swp.config.CfgParser;
import xyz.dogboy.swp.config.SWPConfig;

public class Utils {
    public static final CfgHandler<CfgParser.ConfigItem> whitelist = new CfgHandler<CfgParser.ConfigItem>(SWPConfig.burnableBlocks, CfgParser.ConfigItem::new);
    public static final CfgHandler<CfgParser.ConfigItem> blacklist = new CfgHandler<CfgParser.ConfigItem>(SWPConfig.nonBurnableBlocks, CfgParser.ConfigItem::new);

    public static List<ItemStack> getAllPlanks() {
        NonNullList planks = NonNullList.func_191196_a();
        for (ItemStack plank : OreDictionary.getOres((String)"plankWood")) {
            if (plank.func_77960_j() == Short.MAX_VALUE) {
                plank.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, planks);
                continue;
            }
            planks.add((Object)plank);
        }
        return planks;
    }

    public static boolean isBurnable(ItemStack stack) {
        if (stack.func_190926_b() || blacklist.contains(stack)) {
            return false;
        }
        if (whitelist.contains(stack)) {
            return true;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block == Blocks.field_150350_a) {
            return false;
        }
        IBlockState state = block.func_176223_P();
        return state.func_185904_a().func_76217_h();
    }

    @SideOnly(value=Side.CLIENT)
    public static String getTextureFromBlock(Block block, int meta) {
        IBlockState state = block.func_176203_a(meta);
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state).func_94215_i();
    }
}

