/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.divineweaponry.init;

import net.mcreator.divineweaponry.entity.DeathsunEffectEntity;
import net.mcreator.divineweaponry.entity.DivineJusticeEffectEntity;
import net.mcreator.divineweaponry.entity.SilverlightEffectEntity;
import net.mcreator.divineweaponry.entity.SoullessEffectEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class DivineWeaponryModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"divine_weaponry");
    public static final DeferredHolder<EntityType<?>, EntityType<DivineJusticeEffectEntity>> DIVINE_JUSTICE_EFFECT = DivineWeaponryModEntities.register("divine_justice_effect", EntityType.Builder.of(DivineJusticeEffectEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 0.6f));
    public static final DeferredHolder<EntityType<?>, EntityType<SilverlightEffectEntity>> SILVERLIGHT_EFFECT = DivineWeaponryModEntities.register("silverlight_effect", EntityType.Builder.of(SilverlightEffectEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 0.6f));
    public static final DeferredHolder<EntityType<?>, EntityType<SoullessEffectEntity>> SOULLESS_EFFECT = DivineWeaponryModEntities.register("soulless_effect", EntityType.Builder.of(SoullessEffectEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<DeathsunEffectEntity>> DEATHSUN_EFFECT = DivineWeaponryModEntities.register("deathsun_effect", EntityType.Builder.of(DeathsunEffectEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        DivineJusticeEffectEntity.init(event);
        SilverlightEffectEntity.init(event);
        SoullessEffectEntity.init(event);
        DeathsunEffectEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)DIVINE_JUSTICE_EFFECT.get(), DivineJusticeEffectEntity.createAttributes().build());
        event.put((EntityType)SILVERLIGHT_EFFECT.get(), SilverlightEffectEntity.createAttributes().build());
        event.put((EntityType)SOULLESS_EFFECT.get(), SoullessEffectEntity.createAttributes().build());
        event.put((EntityType)DEATHSUN_EFFECT.get(), DeathsunEffectEntity.createAttributes().build());
    }
}

