/*
 * Decompiled with CFR 0.152.
 */
package net.atired.monsterbooklet.client;

import java.awt.Color;
import net.atired.monsterbooklet.accessors.PlayerAccessor;
import net.atired.monsterbooklet.client.models.BlackMoldModel;
import net.atired.monsterbooklet.client.models.BucketHeadModel;
import net.atired.monsterbooklet.client.models.FiendModel;
import net.atired.monsterbooklet.client.models.GlowMosqoModel;
import net.atired.monsterbooklet.client.models.InfernoModel;
import net.atired.monsterbooklet.client.models.SnipperModel;
import net.atired.monsterbooklet.client.models.YipperModel;
import net.atired.monsterbooklet.client.renderer.BlackMoldRenderer;
import net.atired.monsterbooklet.client.renderer.BucketHeadRenderer;
import net.atired.monsterbooklet.client.renderer.FiendRenderer;
import net.atired.monsterbooklet.client.renderer.FiendThrownEntityRenderer;
import net.atired.monsterbooklet.client.renderer.FlameBallRenderer;
import net.atired.monsterbooklet.client.renderer.GlowMosqoRenderer;
import net.atired.monsterbooklet.client.renderer.InfernoRenderer;
import net.atired.monsterbooklet.client.renderer.SnipperRenderer;
import net.atired.monsterbooklet.client.renderer.YipperRenderer;
import net.atired.monsterbooklet.client.renderstates.BlackMoldRenderState;
import net.atired.monsterbooklet.client.renderstates.FiendRenderState;
import net.atired.monsterbooklet.client.renderstates.GlowMosqoRenderState;
import net.atired.monsterbooklet.client.renderstates.InfernoRenderState;
import net.atired.monsterbooklet.client.renderstates.SnipperRenderState;
import net.atired.monsterbooklet.client.renderstates.YipperRenderState;
import net.atired.monsterbooklet.entities.YipperEntity;
import net.atired.monsterbooklet.init.MBblockInit;
import net.atired.monsterbooklet.init.MBentityTypeInit;
import net.atired.monsterbooklet.init.MBparticleInit;
import net.atired.monsterbooklet.misc.MBgetDatNoise;
import net.atired.monsterbooklet.networking.payload.CleaverPayload;
import net.atired.monsterbooklet.networking.payload.VelSyncPayload;
import net.atired.monsterbooklet.networking.payload.YipperPayload;
import net.atired.monsterbooklet.particles.CleaverParticle;
import net.atired.monsterbooklet.particles.MoldParticle;
import net.atired.monsterbooklet.particles.MoldSmallParticle;
import net.atired.monsterbooklet.particles.MoldSplatParticle;
import net.atired.monsterbooklet.particles.SnipperParticle;
import net.atired.monsterbooklet.particles.SteamedParticle;
import net.atired.monsterbooklet.particles.YipperParticle;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_11515;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_5602;
import net.minecraft.class_5605;
import net.minecraft.class_5607;
import net.minecraft.class_5609;

public class MonsterBookletClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ParticleFactoryRegistry.getInstance().register((class_2396)MBparticleInit.YIPPER_PARTICLE, YipperParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)MBparticleInit.SNIPPER_PARTICLE, SnipperParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)MBparticleInit.CLEAVER_PARTICLE, CleaverParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register(MBparticleInit.STEAMED_PARTICLE, SteamedParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)MBparticleInit.MOLD_PARTICLE, MoldParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)MBparticleInit.MOLDSMALL_PARTICLE, MoldSmallParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)MBparticleInit.MOLDSPLAT_PARTICLE, MoldSplatParticle.Factory::new);
        ColorProviderRegistry.BLOCK.register((state, world, pos, tintIndex) -> {
            float noisy = MBgetDatNoise.sampleNoise3D(pos.method_10263(), pos.method_10264(), pos.method_10260(), 8.0f);
            noisy = Math.clamp(Math.abs(noisy / 4.0f), 0.0f, 1.0f);
            return Color.HSBtoRGB(0.66f, noisy, 1.0f);
        }, (Object[])new class_2248[]{MBblockInit.BLACK_MOLD, MBblockInit.SHORT_MOLD});
        BlockRenderLayerMap.putBlock((class_2248)MBblockInit.BLACK_MOLD, (class_11515)class_11515.field_60925);
        BlockRenderLayerMap.putBlock((class_2248)MBblockInit.SHORT_MOLD, (class_11515)class_11515.field_60925);
        EntityRendererRegistry.register(MBentityTypeInit.YIPPER, context -> new YipperRenderer(context, new YipperModel<YipperRenderState>(YipperModel.getTexturedModelData().method_32109()), 0.6f));
        EntityRendererRegistry.register(MBentityTypeInit.BLACK_MOLD, context -> new BlackMoldRenderer(context, new BlackMoldModel<BlackMoldRenderState>(BlackMoldModel.getTexturedModelData().method_32109()), 0.3f));
        EntityRendererRegistry.register(MBentityTypeInit.FIEND, context -> new FiendRenderer(context, new FiendModel<FiendRenderState>(FiendModel.getTexturedModelData().method_32109()), 0.4f));
        EntityRendererRegistry.register(MBentityTypeInit.SNIPPER, context -> new SnipperRenderer(context, new SnipperModel<SnipperRenderState>(SnipperModel.getTexturedModelData().method_32109()), 0.4f));
        EntityRendererRegistry.register(MBentityTypeInit.INFERNO, context -> new InfernoRenderer(context, new InfernoModel<InfernoRenderState>(InfernoModel.getTexturedModelData().method_32109()), 0.3f));
        EntityRendererRegistry.register(MBentityTypeInit.MOSQO, context -> new GlowMosqoRenderer(context, new GlowMosqoModel<GlowMosqoRenderState>(GlowMosqoModel.getTexturedModelData(0.0f).method_32109()), 0.2f));
        EntityRendererRegistry.register(MBentityTypeInit.FLAMEBALL, FlameBallRenderer::new);
        EntityRendererRegistry.register(MBentityTypeInit.FIEND_BLOCK, FiendThrownEntityRenderer::new);
        EntityRendererRegistry.register(MBentityTypeInit.BUCKETHEAD, context -> new BucketHeadRenderer(context, new BucketHeadModel(class_5607.method_32110((class_5609)BucketHeadModel.getModelData(new class_5605(0.0f), 0.0f), (int)64, (int)64).method_32109()), new BucketHeadModel(context.method_32167(class_5602.field_27642)), new BucketHeadModel(context.method_32167(class_5602.field_27643))));
        this.initpayloads();
    }

    private void initpayloads() {
        PayloadTypeRegistry.playS2C().register(YipperPayload.ID, YipperPayload.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(YipperPayload.ID, (payload, context) -> {
            class_1297 entity = context.client().field_1687.method_8469(payload.entityID());
            class_1297 gamer = context.client().field_1687.method_8469(payload.playerID());
            class_243 movement = new class_243(payload.xVel(), payload.yVel(), payload.zVel());
            if (entity instanceof YipperEntity) {
                YipperEntity yipperEntity = (YipperEntity)entity;
                if (gamer instanceof class_1657) {
                    class_1657 player = (class_1657)gamer;
                    yipperEntity.playerEntities.add(player);
                    yipperEntity.positions.add(movement);
                }
            }
        });
        PayloadTypeRegistry.playS2C().register(VelSyncPayload.ID, VelSyncPayload.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(VelSyncPayload.ID, (payload, context) -> {
            class_1297 gamer = context.client().field_1687.method_8469(payload.playerID());
            class_243 movement = new class_243(payload.xVel(), payload.yVel(), payload.zVel());
            gamer.method_18799(gamer.method_18798().method_1021(0.8));
            gamer.method_60491(movement);
        });
        PayloadTypeRegistry.playS2C().register(CleaverPayload.ID, CleaverPayload.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(CleaverPayload.ID, (payload, context) -> {
            class_1297 gamer = context.client().field_1687.method_8469(payload.playerID());
            if (gamer instanceof PlayerAccessor) {
                PlayerAccessor accessor = (PlayerAccessor)gamer;
                accessor.monsterBooklet$setLastAttackedTicks(20);
            }
        });
    }
}

