/*
 * Decompiled with CFR 0.152.
 */
package net.atired.monsterbooklet.client.renderer;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.atired.monsterbooklet.MonsterBooklet;
import net.atired.monsterbooklet.client.renderstates.GiantFlameProjectileRenderState;
import net.atired.monsterbooklet.entities.GiantFlameBallProjectile;
import net.minecraft.class_10017;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_765;
import net.minecraft.class_897;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class FlameBallRenderer
extends class_897<GiantFlameBallProjectile, GiantFlameProjectileRenderState> {
    private static final Vector3f ROTATION_VECTOR = new Vector3f(0.5f, 0.5f, 0.5f).normalize();
    private static final Vector3f TRANSFORM_VECTOR = new Vector3f(-1.0f, -1.0f, 0.0f);
    public static final class_2960 TEXTURE = MonsterBooklet.id("textures/misc/dirt.png");
    public static final class_2960 TEXTURETIPS = MonsterBooklet.id("textures/misc/tip.png");

    public FlameBallRenderer(class_5617.class_5618 ctx) {
        super(ctx);
    }

    public void render(GiantFlameProjectileRenderState state, class_4587 matrices, class_4597 vertexConsumers, int light) {
        GiantFlameBallProjectile entity = state.projectile;
        float tickDelta = state.tickDelta;
        if (entity.hasTrail()) {
            double x = class_3532.method_16436((double)tickDelta, (double)entity.field_6038, (double)entity.method_23317());
            double y = class_3532.method_16436((double)tickDelta, (double)entity.field_5971, (double)entity.method_23318());
            double z = class_3532.method_16436((double)tickDelta, (double)entity.field_5989, (double)entity.method_23321());
            matrices.method_22903();
            matrices.method_22904(-x, -y, -z);
            this.renderTrail(entity, tickDelta, matrices, vertexConsumers, 1.0f, 1.0f, 1.0f, 1.0f, light, 0.0f);
            matrices.method_22904(x, y, z);
            matrices.method_22909();
        }
        super.method_3936((class_10017)state, matrices, vertexConsumers, light);
    }

    public void updateRenderState(GiantFlameBallProjectile entity, GiantFlameProjectileRenderState state, float tickProgress) {
        state.projectile = entity;
        state.tickDelta = tickProgress;
        super.method_62354((class_1297)entity, (class_10017)state, tickProgress);
    }

    public GiantFlameProjectileRenderState createRenderState() {
        return new GiantFlameProjectileRenderState();
    }

    public boolean shouldRender(GiantFlameBallProjectile entity, class_4604 frustum, double x, double y, double z) {
        return super.method_3933((class_1297)entity, frustum, x, y, z);
    }

    private void renderTrail(GiantFlameBallProjectile entityIn, float partialTicks, class_4587 poseStack, class_4597 bufferIn, float trailR, float trailG, float trailB, float trailA, int packedLightIn, float addedrot) {
        int sampleSize = 12;
        float trailHeight = 1.0f;
        class_243 drawFrom = entityIn.getTrailPosition(0, partialTicks);
        class_4588 vertexconsumer2 = bufferIn.getBuffer(class_1921.method_23580((class_2960)TEXTURETIPS));
        class_243 dir = entityIn.getTrailPosition(1, partialTicks).method_1020(drawFrom).method_1029();
        float yRot = (float)Math.atan2(dir.field_1352, dir.field_1350);
        float pitch = (float)Math.asin(-dir.field_1351);
        List oldPositions = new ArrayList<class_243>(List.of());
        class_4587.class_4665 posestack$pose = poseStack.method_23760();
        Matrix4f matrix4f = posestack$pose.method_23761();
        List<Consumer<Quaternionf>> OLDquaternionfConsumer = List.of(this.rot(yRot, 0.0f, pitch), this.rot(yRot, 1.57f, pitch), this.rot(yRot, 3.14f, pitch), this.rot(yRot, 4.71f, pitch));
        for (Consumer<Quaternionf> quaternionfConsumer : OLDquaternionfConsumer) {
            Quaternionf $$8 = new Quaternionf().setAngleAxis(0.0f, ROTATION_VECTOR.x(), ROTATION_VECTOR.y(), ROTATION_VECTOR.z());
            quaternionfConsumer.accept($$8);
            $$8.transform(TRANSFORM_VECTOR);
            oldPositions.add(new class_243(new Vector3f(trailHeight / 2.0f, 0.0f, 0.0f).rotate((Quaternionfc)$$8)).method_1019(drawFrom));
        }
        packedLightIn = 250;
        vertexconsumer2.method_22918(matrix4f, (float)((class_243)oldPositions.get((int)0)).field_1352, (float)((class_243)oldPositions.get((int)0)).field_1351, (float)((class_243)oldPositions.get((int)0)).field_1350).method_22915(trailR, trailG, trailB, trailA).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(packedLightIn).method_60831(posestack$pose, 0.0f, 1.0f, 0.0f);
        vertexconsumer2.method_22918(matrix4f, (float)((class_243)oldPositions.get((int)1)).field_1352, (float)((class_243)oldPositions.get((int)1)).field_1351, (float)((class_243)oldPositions.get((int)1)).field_1350).method_22915(trailR, trailG, trailB, trailA).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(packedLightIn).method_60831(posestack$pose, 0.0f, 1.0f, 0.0f);
        vertexconsumer2.method_22918(matrix4f, (float)((class_243)oldPositions.get((int)2)).field_1352, (float)((class_243)oldPositions.get((int)2)).field_1351, (float)((class_243)oldPositions.get((int)2)).field_1350).method_22915(trailR, trailG, trailB, trailA).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(packedLightIn).method_60831(posestack$pose, 0.0f, 1.0f, 0.0f);
        vertexconsumer2.method_22918(matrix4f, (float)((class_243)oldPositions.get((int)3)).field_1352, (float)((class_243)oldPositions.get((int)3)).field_1351, (float)((class_243)oldPositions.get((int)3)).field_1350).method_22915(trailR, trailG, trailB, trailA).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(packedLightIn).method_60831(posestack$pose, 0.0f, 1.0f, 0.0f);
        class_4588 vertexconsumer = bufferIn.getBuffer(class_1921.method_23580((class_2960)TEXTURE));
        for (int samples = 0; samples < sampleSize; ++samples) {
            class_243 sample = entityIn.getTrailPosition(samples + 1, partialTicks);
            dir = sample.method_1020(entityIn.getTrailPosition(samples, partialTicks)).method_1029();
            yRot = (float)Math.atan2(dir.field_1352, dir.field_1350);
            pitch = (float)Math.asin(-dir.field_1351);
            List<Consumer<Quaternionf>> consumerList = List.of(this.rot(yRot, 0.0f, pitch), this.rot(yRot, 1.57f, pitch), this.rot(yRot, 3.14f, pitch), this.rot(yRot, 4.71f, pitch));
            int light2 = class_765.method_23687((int)this.method_24087((class_1297)entityIn, class_2338.method_49637((double)sample.method_10216(), (double)sample.method_10214(), (double)sample.method_10215())), (int)this.method_27950((class_1297)entityIn, class_2338.method_49637((double)sample.method_10216(), (double)sample.method_10214(), (double)sample.method_10215())));
            int light1 = class_765.method_23687((int)this.method_24087((class_1297)entityIn, class_2338.method_49637((double)sample.method_10216(), (double)sample.method_10214(), (double)sample.method_10215())), (int)this.method_27950((class_1297)entityIn, class_2338.method_49637((double)sample.method_10216(), (double)sample.method_10214(), (double)sample.method_10215())));
            ArrayList<class_243> newPositions = new ArrayList<class_243>(List.of());
            light1 = 250;
            light2 = 250;
            class_243 draw2 = sample;
            for (Consumer<Quaternionf> quaternionfConsumer : consumerList) {
                Quaternionf $$8 = new Quaternionf().setAngleAxis(0.0f, ROTATION_VECTOR.x(), ROTATION_VECTOR.y(), ROTATION_VECTOR.z());
                quaternionfConsumer.accept($$8);
                $$8.transform(TRANSFORM_VECTOR);
                newPositions.add(new class_243(new Vector3f((float)Math.pow((double)trailHeight * (1.0 - ((double)samples + 1.0) / (double)sampleSize), 0.4f), 0.0f, 0.0f).rotate((Quaternionfc)$$8)).method_1019(draw2));
            }
            posestack$pose = poseStack.method_23760();
            matrix4f = posestack$pose.method_23761();
            int i = 0;
            while ((long)i < (long)newPositions.size()) {
                int j = (i + 1) % newPositions.size();
                vertexconsumer.method_22918(matrix4f, (float)((class_243)oldPositions.get((int)j)).field_1352, (float)((class_243)oldPositions.get((int)j)).field_1351, (float)((class_243)oldPositions.get((int)j)).field_1350).method_22915(trailR, trailG, trailB, trailA).method_22913((float)samples / (float)sampleSize, (float)(i + 1) / (float)newPositions.size()).method_22922(class_4608.field_21444).method_60803(light1).method_60831(posestack$pose, 0.0f, 1.0f, 0.0f);
                vertexconsumer.method_22918(matrix4f, (float)((class_243)newPositions.get((int)j)).field_1352, (float)((class_243)newPositions.get((int)j)).field_1351, (float)((class_243)newPositions.get((int)j)).field_1350).method_22915(trailR, trailG, trailB, trailA).method_22913((float)(samples + 1) / (float)sampleSize, (float)(i + 1) / (float)newPositions.size()).method_22922(class_4608.field_21444).method_60803(light2).method_60831(posestack$pose, 0.0f, 1.0f, 0.0f);
                vertexconsumer.method_22918(matrix4f, (float)((class_243)newPositions.get((int)i)).field_1352, (float)((class_243)newPositions.get((int)i)).field_1351, (float)((class_243)newPositions.get((int)i)).field_1350).method_22915(trailR, trailG, trailB, trailA).method_22913((float)(samples + 1) / (float)sampleSize, (float)i / (float)newPositions.size()).method_22922(class_4608.field_21444).method_60803(light2).method_60831(posestack$pose, 0.0f, 1.0f, 0.0f);
                vertexconsumer.method_22918(matrix4f, (float)((class_243)oldPositions.get((int)i)).field_1352, (float)((class_243)oldPositions.get((int)i)).field_1351, (float)((class_243)oldPositions.get((int)i)).field_1350).method_22915(trailR, trailG, trailB, trailA).method_22913((float)samples / (float)sampleSize, (float)i / (float)newPositions.size()).method_22922(class_4608.field_21444).method_60803(light1).method_60831(posestack$pose, 0.0f, 1.0f, 0.0f);
                ++i;
            }
            drawFrom = sample;
            oldPositions = (List)newPositions.clone();
            newPositions.clear();
        }
    }

    private Consumer<Quaternionf> rot(float yRot, float xRot, float zRot) {
        return p_253347_ -> p_253347_.mul((Quaternionfc)new Quaternionf().rotationYXZ(yRot, zRot, xRot));
    }
}

