/*
 * Decompiled with CFR 0.152.
 */
package net.atired.monsterbooklet.entities;

import java.util.EnumSet;
import java.util.List;
import net.atired.monsterbooklet.entities.FiendThrownBlockEntity;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1370;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1541;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1680;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class FiendEntity
extends class_1588 {
    private class_2680 block;
    protected static final class_2940<class_2680> STATE_TRACKED_DATA;
    protected static final class_2940<Integer> WINDUP_TICKS;
    private static final List<class_2248> BLOCK_LIST;

    public FiendEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    public void setBlockState(class_2680 state) {
        this.field_6011.method_12778(STATE_TRACKED_DATA, (Object)state);
    }

    public class_2680 getBlockState() {
        return (class_2680)this.field_6011.method_12789(STATE_TRACKED_DATA);
    }

    public void setWindupTicks(int windupTicks) {
        this.field_6011.method_12778(WINDUP_TICKS, (Object)windupTicks);
    }

    public int getWindupTicks() {
        return (Integer)this.field_6011.method_12789(WINDUP_TICKS);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.setBlockState(BLOCK_LIST.get(this.method_59922().method_39332(0, BLOCK_LIST.size() - 1)).method_9564());
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public void method_5773() {
        if (this.getWindupTicks() >= 0) {
            this.setWindupTicks(this.getWindupTicks() + 1);
        } else if (this.getWindupTicks() < -1 && this.method_24828() && this.method_37908().field_9236) {
            for (int i = 0; i < 5; ++i) {
                this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_50248, this.method_37908().method_8320(this.method_24515().method_10069(0, -1, 0))), this.method_23322(0.4), this.method_23318(), this.method_23325(0.4), 0.0, 0.3, 0.0);
            }
        }
        super.method_5773();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(STATE_TRACKED_DATA, (Object)class_2246.field_10340.method_9564());
        builder.method_56912(WINDUP_TICKS, (Object)-1);
    }

    public static class_5132.class_5133 createFiendAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 15.0).method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, (double)0.15f).method_26868(class_5134.field_23721, 0.0).method_26868(class_5134.field_23724, 3.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new PeltWithBlocksGoal(this));
        this.field_6201.method_6277(3, (class_1352)new FiendAttackGoal(this, 0.3, true));
        this.field_6201.method_6277(5, (class_1352)new class_1370((class_1314)this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 0.5));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public void writeCustomDataToNbt(class_2487 nbt) {
        nbt.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)this.getBlockState()));
    }

    protected void method_5652(class_11372 view) {
        view.method_71468("BlockState", class_2680.field_24734, (Object)this.getBlockState());
        super.method_5652(view);
    }

    protected void method_5749(class_11368 view) {
        if (view.method_71426("BlockState", class_2680.field_24734).isPresent()) {
            this.setBlockState((class_2680)view.method_71426("BlockState", class_2680.field_24734).get());
        }
        super.method_5749(view);
    }

    public static boolean canFiendSpawn(class_1299<? extends class_1588> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return FiendEntity.method_20680(type, (class_5425)world, (class_3730)spawnReason, (class_2338)pos, (class_5819)random) && pos.method_10264() < 20;
    }

    static {
        BLOCK_LIST = List.of(class_2246.field_10375, class_2246.field_10340, class_2246.field_10115, class_2246.field_10508, class_2246.field_28888, class_2246.field_10535, class_2246.field_10491);
        STATE_TRACKED_DATA = class_2945.method_12791(FiendEntity.class, (class_2941)class_2943.field_13312);
        WINDUP_TICKS = class_2945.method_12791(FiendEntity.class, (class_2941)class_2943.field_13327);
    }

    private static class PeltWithBlocksGoal
    extends class_1352 {
        private final FiendEntity fiend;
        private int throwTicks;
        private int targetVisibleTicks;

        public PeltWithBlocksGoal(FiendEntity fiend) {
            this.fiend = fiend;
            this.throwTicks = 0;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 livingEntity = this.fiend.method_5968();
            return livingEntity != null && livingEntity.method_5805() && this.fiend.method_18395(livingEntity) && !(this.fiend.getBlockState().method_26204() instanceof class_2189);
        }

        public void method_6269() {
            this.throwTicks = 0;
            super.method_6269();
        }

        public void method_6270() {
            this.throwTicks = 0;
            this.targetVisibleTicks = 0;
            if (this.fiend != null) {
                this.fiend.setWindupTicks(-1);
            }
            super.method_6270();
        }

        public void method_6268() {
            boolean bl;
            class_1309 livingEntity = this.fiend.method_5968();
            if (livingEntity != null && (bl = this.fiend.method_5985().method_6369((class_1297)livingEntity))) {
                this.fiend.method_5988().method_6226((class_1297)livingEntity, 10.0f, 10.0f);
                ++this.targetVisibleTicks;
            }
            if (this.targetVisibleTicks >= 10 && !this.fiend.method_37908().field_9236) {
                if (this.throwTicks == 0) {
                    this.fiend.setWindupTicks(0);
                }
                ++this.throwTicks;
                if (this.throwTicks == 3) {
                    this.fiend.method_37908().method_8396((class_1297)this.fiend, this.fiend.method_24515(), class_3417.field_14711, class_3419.field_15254, 4.0f, 0.3f);
                    class_2680 state = this.fiend.getBlockState();
                    if (state.method_26204() == class_2246.field_10375) {
                        class_1541 entity = new class_1541(this.fiend.method_37908(), this.fiend.method_23317(), this.fiend.method_23323(0.9), this.fiend.method_23321(), (class_1309)this.fiend);
                        class_243 dir = livingEntity.method_19538().method_1020(this.fiend.method_19538()).method_1031(0.0, 3.0, 0.0).method_1029().method_1021(Math.pow(livingEntity.method_5739((class_1297)this.fiend), 0.7f) / 8.0 + (double)0.1f);
                        entity.method_18799(dir);
                        entity.method_6967(40);
                        this.fiend.method_37908().method_8649((class_1297)entity);
                    } else {
                        FiendThrownBlockEntity entity = new FiendThrownBlockEntity(this.fiend.method_37908(), this.fiend.method_23317(), this.fiend.method_23323(0.9), this.fiend.method_23321(), (class_1309)this.fiend);
                        class_243 dir = livingEntity.method_19538().method_1020(this.fiend.method_19538()).method_1031(0.0, 7.0, 0.0).method_1029().method_1021(Math.pow(livingEntity.method_5739((class_1297)this.fiend), 0.7f) / 11.0 + (double)0.1f);
                        entity.method_18799(dir);
                        entity.setBlockState(state);
                        this.fiend.method_37908().method_8649((class_1297)entity);
                        if (state.method_26204() == class_2246.field_10491) {
                            for (int i = 0; i < 20; ++i) {
                                class_1680 snowballEntity = new class_1680(this.fiend.method_37908(), this.fiend.method_23317(), this.fiend.method_23323(0.9), this.fiend.method_23321(), new class_1799((class_1935)class_1802.field_8543));
                                snowballEntity.method_7432((class_1297)this.fiend);
                                class_243 newDir = new class_243(this.fiend.method_59922().method_43385(dir.method_10216(), 3.0), this.fiend.method_59922().method_43385(dir.method_10214(), 3.0), this.fiend.method_59922().method_43385(dir.method_10215(), 3.0)).method_1029().method_1021(dir.method_1033());
                                snowballEntity.method_18799(newDir);
                                this.fiend.method_37908().method_8649((class_1297)snowballEntity);
                            }
                        }
                    }
                    this.fiend.setBlockState(class_2246.field_10124.method_9564());
                    this.method_6270();
                }
            }
            super.method_6268();
        }
    }

    private static class FiendAttackGoal
    extends class_1366 {
        private int recoupTicks;
        private int preTicks;
        private final FiendEntity fiend;

        public FiendAttackGoal(FiendEntity mob, double speed, boolean pauseWhenMobIdle) {
            super((class_1314)mob, speed, pauseWhenMobIdle);
            this.fiend = mob;
        }

        public void method_6268() {
            class_1309 livingEntity = this.fiend.method_5968();
            if (livingEntity != null) {
                boolean bl = this.fiend.method_5985().method_6369((class_1297)livingEntity);
                if (this.fiend.method_5739((class_1297)livingEntity) > 5.0f) {
                    if (this.preTicks == 0) {
                        this.fiend.method_5942().method_6344((double)0.075f);
                    }
                    ++this.preTicks;
                    if (this.preTicks > 50) {
                        this.fiend.method_5942().method_6340();
                        if (this.recoupTicks == 0) {
                            this.fiend.setWindupTicks(-2);
                        }
                        ++this.recoupTicks;
                        if (this.recoupTicks >= 40) {
                            this.fiend.setBlockState(BLOCK_LIST.get(this.fiend.method_59922().method_39332(0, BLOCK_LIST.size() - 1)).method_9564());
                            this.method_6270();
                        }
                        return;
                    }
                } else if (this.recoupTicks > 0 || this.preTicks > 0) {
                    this.fiend.method_5942().method_6344((double)0.3f);
                    this.fiend.setWindupTicks(-1);
                    this.recoupTicks = Math.clamp((long)(this.recoupTicks - 1), 0, 12);
                    this.preTicks = 0;
                    super.method_6268();
                    return;
                }
            }
            super.method_6268();
        }

        public void method_6270() {
            this.fiend.setWindupTicks(-1);
            this.recoupTicks = 0;
            this.preTicks = 0;
            super.method_6270();
        }

        public boolean method_6264() {
            if (this.fiend.getBlockState().method_26215()) {
                return super.method_6264();
            }
            return false;
        }
    }
}

