/*
 * Decompiled with CFR 0.152.
 */
package de.firecrystal.lc;

import de.firecrystal.lc.LibraryCubeListener;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Lectern;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class LibraryCubePlugin
extends JavaPlugin {
    private final List<Material> terracottaColors = Arrays.asList(Material.WHITE_TERRACOTTA, Material.ORANGE_TERRACOTTA, Material.MAGENTA_TERRACOTTA, Material.LIGHT_BLUE_TERRACOTTA, Material.YELLOW_TERRACOTTA, Material.LIME_TERRACOTTA, Material.PINK_TERRACOTTA, Material.GRAY_TERRACOTTA, Material.LIGHT_GRAY_TERRACOTTA, Material.CYAN_TERRACOTTA, Material.PURPLE_TERRACOTTA, Material.BLUE_TERRACOTTA, Material.BROWN_TERRACOTTA, Material.GREEN_TERRACOTTA, Material.RED_TERRACOTTA, Material.BLACK_TERRACOTTA, Material.AIR);
    private long currentAddress = 0L;
    private int generationMode = 1;
    private int universalSpeed = 10;
    private BukkitTask universalTask = null;

    public void onEnable() {
        this.getLogger().info("LibraryCubePlugin enabled!");
        this.getServer().getPluginManager().registerEvents((Listener)new LibraryCubeListener(this), (Plugin)this);
        this.getCommand("librarycube").setExecutor((CommandExecutor)this);
        this.currentAddress = this.getConfig().getLong("current-address", this.generateRandomStartAddress());
        this.generationMode = this.getConfig().getInt("generation-mode", 1);
        this.universalSpeed = this.getConfig().getInt("universal-speed", 10);
        this.saveConfig();
    }

    public void onDisable() {
        this.getLogger().info("LibraryCubePlugin disabled!");
        this.getConfig().set("current-address", (Object)this.currentAddress);
        this.getConfig().set("generation-mode", (Object)this.generationMode);
        this.getConfig().set("universal-speed", (Object)this.universalSpeed);
        this.saveConfig();
        if (this.universalTask != null) {
            this.universalTask.cancel();
        }
    }

    private long generateRandomStartAddress() {
        return 1000000L + new Random().nextLong(999000000L);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("librarycube")) {
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase("create")) {
                    this.createLibraryWorld(sender);
                    return true;
                }
                if (args[0].equalsIgnoreCase("address")) {
                    if (args.length > 1) {
                        try {
                            long newAddress;
                            this.currentAddress = newAddress = Long.parseLong(args[1]);
                            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Address set to " + this.currentAddress + ".");
                            World world = this.getServer().getWorld("LibraryWorld");
                            if (world != null) {
                                this.generateLibraryStructure(world);
                                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Chamber regenerated.");
                            }
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid address!");
                        }
                    } else {
                        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Current address: " + this.currentAddress);
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("next")) {
                    ++this.currentAddress;
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Next chamber: " + this.currentAddress);
                    World world = this.getServer().getWorld("LibraryWorld");
                    if (world != null) {
                        this.generateLibraryStructure(world);
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("prev")) {
                    if (this.currentAddress > 0L) {
                        --this.currentAddress;
                    }
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Previous chamber: " + this.currentAddress);
                    World world = this.getServer().getWorld("LibraryWorld");
                    if (world != null) {
                        this.generateLibraryStructure(world);
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("random")) {
                    this.currentAddress = this.generateRandomStartAddress();
                    sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Random chamber: " + this.currentAddress);
                    World world = this.getServer().getWorld("LibraryWorld");
                    if (world != null) {
                        this.generateLibraryStructure(world);
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("change")) {
                    block35: {
                        if (args.length > 1) {
                            try {
                                int mode = Integer.parseInt(args[1]);
                                if (mode == 1 || mode == 2) {
                                    this.generationMode = mode;
                                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Generation mode set to " + mode + ".");
                                    World world = this.getServer().getWorld("LibraryWorld");
                                    if (world != null) {
                                        this.generateLibraryStructure(world);
                                        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Chamber regenerated.");
                                    }
                                    break block35;
                                }
                                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid mode! Choose 1 or 2.");
                            }
                            catch (NumberFormatException e) {
                                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid mode! Choose 1 or 2.");
                            }
                        } else {
                            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Current mode: " + this.generationMode);
                            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /librarycube change <1|2>");
                        }
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("universal")) {
                    if (this.universalTask != null && !this.universalTask.isCancelled()) {
                        this.universalTask.cancel();
                        this.universalTask = null;
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Universal navigation stopped.");
                    } else {
                        this.currentAddress = this.generateRandomStartAddress();
                        World world = this.getServer().getWorld("LibraryWorld");
                        if (world != null) {
                            this.generateLibraryStructure(world);
                            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Universal navigation started. Chamber: " + this.currentAddress);
                        }
                        this.universalTask = this.getServer().getScheduler().runTaskTimer((Plugin)this, () -> this.navigateToNextRoom(), (long)this.universalSpeed * 20L, (long)this.universalSpeed * 20L);
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("speed")) {
                    block36: {
                        if (args.length > 1) {
                            try {
                                int speed = Integer.parseInt(args[1]);
                                if (speed > 0) {
                                    this.universalSpeed = speed;
                                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Speed set to " + speed + " seconds per chamber.");
                                    if (this.universalTask != null && !this.universalTask.isCancelled()) {
                                        this.universalTask.cancel();
                                        this.universalTask = this.getServer().getScheduler().runTaskTimer((Plugin)this, () -> this.navigateToNextRoom(), 20L, (long)this.universalSpeed * 20L);
                                        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Universal navigation restarted with new speed.");
                                    }
                                    break block36;
                                }
                                sender.sendMessage(String.valueOf(ChatColor.RED) + "Speed must be greater than 0!");
                            }
                            catch (NumberFormatException e) {
                                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid value for speed!");
                            }
                        } else {
                            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Current speed: " + this.universalSpeed + " seconds.");
                            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /librarycube speed [value]");
                        }
                    }
                    return true;
                }
            }
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /lc create|address [value]|next|prev|random|change [1|2]|universal|speed [value]");
            return true;
        }
        return false;
    }

    private void createLibraryWorld(CommandSender sender) {
        World world = this.getServer().getWorld("LibraryWorld");
        if (world == null) {
            WorldCreator creator = new WorldCreator("LibraryWorld");
            creator.type(WorldType.FLAT);
            creator.generator((ChunkGenerator)new EmptyWorldGenerator());
            creator.generateStructures(false);
            world = creator.createWorld();
            if (world == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Error creating world!");
                return;
            }
        }
        this.generateLibraryStructure(world);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Library of Babel chamber successfully generated! Address: " + this.currentAddress);
        if (sender instanceof Player) {
            Player player = (Player)sender;
            player.teleport(new Location(world, 0.0, 66.0, 0.0));
        }
    }

    public void generateLibraryStructure(World world) {
        int roomSize = 12;
        int platformY = 64;
        for (int x = -roomSize / 2; x <= roomSize / 2; ++x) {
            for (int z = -roomSize / 2; z <= roomSize / 2; ++z) {
                for (int y = platformY; y <= platformY + roomSize; ++y) {
                    Block block = world.getBlockAt(x, y, z);
                    if (y == platformY) {
                        block.setType(Material.QUARTZ_BLOCK);
                        continue;
                    }
                    if (y == platformY + roomSize) {
                        block.setType(Material.QUARTZ_BLOCK);
                        continue;
                    }
                    if (x == -roomSize / 2 || x == roomSize / 2 || z == -roomSize / 2 || z == roomSize / 2) {
                        block.setType(Material.QUARTZ_BLOCK);
                        continue;
                    }
                    block.setType(Material.AIR);
                }
            }
        }
        this.generateAllCombinations(world, platformY);
        this.createNavigationElements(world, platformY);
        this.createAddressBook(world, platformY);
        world.setSpawnLocation(0, platformY + 1, 0);
    }

    private void generateAllCombinations(World world, int platformY) {
        Random random = new Random(this.currentAddress);
        List<Object> materialsToUse = this.generationMode == 1 ? this.terracottaColors : Arrays.stream(Material.values()).filter(Material::isBlock).collect(Collectors.toList());
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                for (int y = platformY + 1; y < platformY + 11; ++y) {
                    Material material = (Material)materialsToUse.get(random.nextInt(materialsToUse.size()));
                    world.getBlockAt(x, y, z).setType(material);
                }
            }
        }
    }

    private void createNavigationElements(World world, int platformY) {
        Block buttonBlock = world.getBlockAt(-5, platformY + 2, 0);
        buttonBlock.setType(Material.STONE_BUTTON);
        BlockData buttonData = buttonBlock.getBlockData();
        if (buttonData instanceof Directional) {
            ((Directional)buttonData).setFacing(BlockFace.EAST);
        }
        buttonBlock.setBlockData(buttonData);
        Block signBlock = world.getBlockAt(-5, platformY + 3, 0);
        signBlock.setType(Material.OAK_WALL_SIGN);
        BlockData signData = signBlock.getBlockData();
        if (signData instanceof Directional) {
            ((Directional)signData).setFacing(BlockFace.EAST);
        }
        signBlock.setBlockData(signData);
        Sign sign = (Sign)signBlock.getState();
        sign.setLine(0, String.valueOf(ChatColor.GOLD) + "Navigation");
        sign.setLine(1, String.valueOf(ChatColor.BLUE) + "Press the button");
        sign.setLine(2, String.valueOf(ChatColor.BLUE) + "for the next");
        sign.setLine(3, String.valueOf(ChatColor.BLUE) + "chamber");
        sign.update();
        Block lecternBlock = world.getBlockAt(-5, platformY + 1, -1);
        lecternBlock.setType(Material.LECTERN);
        BlockData lecternData = lecternBlock.getBlockData();
        if (lecternData instanceof Directional) {
            ((Directional)lecternData).setFacing(BlockFace.EAST);
        }
        lecternBlock.setBlockData(lecternData);
    }

    private void createAddressBook(World world, int platformY) {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)book.getItemMeta();
        meta.setTitle("Library of Babel");
        meta.setAuthor("The Librarian");
        String page1 = String.valueOf(ChatColor.DARK_PURPLE) + "Chamber No:\n" + String.valueOf(ChatColor.BOLD) + String.valueOf(ChatColor.GOLD) + this.currentAddress + "\n\n" + String.valueOf(ChatColor.BLACK) + "This chamber contains\na unique\ncombination of\nstructures and\narrangements.\n\nEvery chamber is\ndeterministically\ngenerated based on\nits address.";
        meta.addPage(new String[]{page1});
        book.setItemMeta((ItemMeta)meta);
        Block lecternBlock = world.getBlockAt(-5, platformY + 1, -1);
        if (lecternBlock.getType() == Material.LECTERN) {
            Lectern lectern = (Lectern)lecternBlock.getState();
            lectern.getInventory().setItem(0, book);
        }
    }

    public void navigateToNextRoom() {
        ++this.currentAddress;
        this.getConfig().set("current-address", (Object)this.currentAddress);
        this.saveConfig();
        World world = this.getServer().getWorld("LibraryWorld");
        if (world != null) {
            this.generateLibraryStructure(world);
            for (Player player : world.getPlayers()) {
                player.sendTitle(String.valueOf(ChatColor.GOLD) + "Chamber " + this.currentAddress, String.valueOf(ChatColor.GRAY) + "Library of Babel", 10, 70, 20);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "You enter chamber " + this.currentAddress + " of the infinite library.");
            }
        }
    }

    public long getCurrentAddress() {
        return this.currentAddress;
    }

    public int getGenerationMode() {
        return this.generationMode;
    }

    public static class EmptyWorldGenerator
    extends ChunkGenerator {
        @NotNull
        public ChunkGenerator.ChunkData generateChunkData(@NotNull World world, @NotNull Random random, int x, int z, @NotNull ChunkGenerator.BiomeGrid biome) {
            ChunkGenerator.ChunkData chunkData = this.createChunkData(world);
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    biome.setBiome(i, j, Biome.PLAINS);
                }
            }
            return chunkData;
        }
    }
}

