package com.criticalrange.mixin.optimizations.beacon_beam_rendering;

import com.criticalrange.VulkanModExtra;
import net.minecraft.class_2580;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_822;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * Beacon beam rendering optimization mixin
 * Controls beacon beam rendering and height limiting
 */
@Mixin(class_822.class)
public class MixinBeaconRenderer {

    @Inject(method = "render", at = @At("HEAD"), cancellable = true)
    private void vulkanmodExtra$checkBeaconRendering(class_2580 beaconBlockEntity, float partialTick, 
            class_4587 poseStack, class_4597 multiBufferSource, 
            int packedLight, int packedOverlay, CallbackInfo ci) {
        // Cancel beacon beam rendering if disabled
        if (!VulkanModExtra.CONFIG.renderSettings.beaconBeam) {
            ci.cancel();
        }
        
        // Height limiting functionality
        if (VulkanModExtra.CONFIG.renderSettings.limitBeaconBeamHeight && beaconBlockEntity.method_10997() != null) {
            int worldHeight = beaconBlockEntity.method_10997().method_31600();
            int beaconY = beaconBlockEntity.method_11016().method_10264();
            
            // If beacon is too high and height limiting is enabled, don't render
            if (beaconY > worldHeight - 64) { // Limit beams near world height
                ci.cancel();
            }
        }
    }
}
