package com.criticalrange;

import com.criticalrange.config.VulkanModExtraConfig;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VulkanModExtra implements ModInitializer {
	public static final String MOD_ID = "vulkanmod-extra";

	// This logger is used to write text to the console and the log file.
	// It is considered best practice to use your mod id as the logger's name.
	// That way, it's clear which mod wrote info, warnings, and errors.
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

	public static VulkanModExtraConfig CONFIG;

	// Reference to the Config class for external access to enums
	public static final Class<?> Config = VulkanModExtraConfig.class;

	@Override
	public void onInitialize() {
		// This code runs as soon as Minecraft is in a mod-load-ready state.
		// However, some things (like resources) may still be uninitialized.
		// Proceed with mild caution.

		LOGGER.info("Initializing VulkanMod Extra...");

		CONFIG = VulkanModExtraConfig.load();

		// Register commands for status checking
		registerCommands();

		LOGGER.info("VulkanMod Extra initialized successfully!");
		LOGGER.info("Use '/vulkanmod-extra' command to check feature status");
	}

	private void registerCommands() {
		CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
			dispatcher.register(class_2170.method_9247("vulkanmod-extra")
				.requires(source -> source.method_9259(0)) // Allow anyone to use
				.executes(context -> {
					class_2168 source = context.getSource();
					source.method_9226(() -> class_2561.method_43470("§6=== VulkanMod Extra Status ==="), false);

					// HUD Features
					source.method_9226(() -> class_2561.method_43470("§eHUD Features:"), false);
					source.method_9226(() -> class_2561.method_43470("§7  FPS Display: " + (CONFIG.extraSettings.showFps ? "§aEnabled" : "§cDisabled")), false);
					var fpsMode = CONFIG.extraSettings.fpsDisplayMode;
					source.method_9226(() -> class_2561.method_43470("§7  FPS Mode: §a" + fpsMode.name()), false);
					source.method_9226(() -> class_2561.method_43470("§7  Coordinates: " + (CONFIG.extraSettings.showCoords ? "§aEnabled" : "§cDisabled")), false);
					source.method_9226(() -> class_2561.method_43470("§7  Toasts: " + (CONFIG.extraSettings.toasts ? "§aEnabled" : "§cDisabled")), false);

					// Performance Features
					source.method_9226(() -> class_2561.method_43470("§ePerformance Features:"), false);
					source.method_9226(() -> class_2561.method_43470("§7  Instant Sneak: " + (CONFIG.extraSettings.instantSneak ? "§aEnabled" : "§cDisabled")), false);
					source.method_9226(() -> class_2561.method_43470("§7  Adaptive Sync: " + (CONFIG.extraSettings.useAdaptiveSync ? "§aEnabled" : "§cDisabled")), false);
					source.method_9226(() -> class_2561.method_43470("§7  Steady Debug HUD: " + (CONFIG.extraSettings.steadyDebugHud ? "§aEnabled" : "§cDisabled")), false);

					// Animation & Particles
					source.method_9226(() -> class_2561.method_43470("§eAnimation & Particles:"), false);
					source.method_9226(() -> class_2561.method_43470("§7  Animations: " + (CONFIG.animationSettings.animation ? "§aEnabled" : "§cDisabled")), false);
					source.method_9226(() -> class_2561.method_43470("§7  Particles: " + (CONFIG.particleSettings.particles ? "§aEnabled" : "§cDisabled")), false);

					// Other Features
					source.method_9226(() -> class_2561.method_43470("§eOther Features:"), false);
					source.method_9226(() -> class_2561.method_43470("§7  Shader Prevention: " + (CONFIG.extraSettings.preventShaders ? "§aEnabled" : "§cDisabled")), false);
					source.method_9226(() -> class_2561.method_43470("§7  Mac Resolution Reduction: " + (CONFIG.extraSettings.reduceResolutionOnMac ? "§aEnabled" : "§cDisabled")), false);

					source.method_9226(() -> class_2561.method_43470("§6Use /vulkanmod-extra reload to reload config"), false);
					source.method_9226(() -> class_2561.method_43470("§7Note: GUI integration disabled due to VulkanMod conflicts"), false);
					return 1;
				}));

			// Reload command
			dispatcher.register(class_2170.method_9247("vulkanmod-extra")
				.then(class_2170.method_9247("reload")
					.requires(source -> source.method_9259(2)) // Require OP level 2
					.executes(context -> {
						CONFIG = VulkanModExtraConfig.load();
						context.getSource().method_9226(() -> class_2561.method_43470("§aVulkanMod Extra config reloaded!"), false);
						return 1;
					})));
		});
	}
}