package com.criticalrange.mixin.animation;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;

/**
 * Performance-focused animation optimization mixin
 * Disables expensive texture animations for better performance
 */
@Mixin(class_1059.class)
public abstract class MixinTextureAtlas {

    @Unique
    private static final List<class_2960> DISABLED_ANIMATIONS = List.of(
        // Fire animations (highest performance impact)
        class_2960.method_60655("minecraft", "block/fire_0"),
        class_2960.method_60655("minecraft", "block/fire_1"),
        class_2960.method_60655("minecraft", "block/soul_fire_0"),
        class_2960.method_60655("minecraft", "block/soul_fire_1"),
        class_2960.method_60655("minecraft", "block/campfire_fire"),
        class_2960.method_60655("minecraft", "block/campfire_log_lit"),
        class_2960.method_60655("minecraft", "block/soul_campfire_fire"),
        class_2960.method_60655("minecraft", "block/soul_campfire_log_lit"),

        // Water animations (moderate performance impact)
        class_2960.method_60655("minecraft", "block/water_still"),
        class_2960.method_60655("minecraft", "block/water_flow"),

        // Lava animations (moderate performance impact)
        class_2960.method_60655("minecraft", "block/lava_still"),
        class_2960.method_60655("minecraft", "block/lava_flow"),

        // Portal animations (minimal performance impact but visually jarring)
        class_2960.method_60655("minecraft", "block/nether_portal")
    );

    @Redirect(method = "upload", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;createTicker()Lnet/minecraft/client/renderer/texture/TextureAtlasSprite$Ticker;"), require = 0)
    public class_1058.class_7770 vulkanmodExtra$optimizeAnimatedSprites(class_1058 instance) {
        // Use config settings to control animations
        if (instance.method_45851() != null) {
            class_2960 textureName = instance.method_45851().method_45816();
            if (shouldDisableAnimation(textureName)) {
                return null; // Disable animation for performance
            }
        }
        return instance.method_33437(); // Keep animation for everything else
    }

    private boolean shouldDisableAnimation(class_2960 textureName) {
        String path = textureName.method_12832();
        // Check config settings to determine if animation should be disabled
        if (path.contains("water") && !com.criticalrange.VulkanModExtra.CONFIG.animationSettings.water) {
            return true;
        }
        if (path.contains("lava") && !com.criticalrange.VulkanModExtra.CONFIG.animationSettings.lava) {
            return true;
        }
        if (path.contains("fire") && !com.criticalrange.VulkanModExtra.CONFIG.animationSettings.fire) {
            return true;
        }
        if (path.contains("nether_portal") && !com.criticalrange.VulkanModExtra.CONFIG.animationSettings.portal) {
            return true;
        }
        return false;
    }
}
