package com.criticalrange.mixin.biome_colors;

import com.criticalrange.VulkanModExtra;
import com.criticalrange.client.config.VulkanModExtraClientConfig;
import net.minecraft.class_1959;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

/**
 * Biome colors control mixin
 * Controls biome color rendering based on user preferences
 */
@Mixin(class_1959.class)
public class MixinBiomeColors {

    @Inject(method = "getGrassColor", at = @At("HEAD"), cancellable = true)
    private void vulkanmodExtra$controlGrassColors(CallbackInfoReturnable<Integer> cir) {
        var clientConfig = VulkanModExtraClientConfig.getInstance();

        // Check if biome colors are disabled
        if (!clientConfig.detailSettings.biomeColors) {
            // Return a default grass color
            cir.setReturnValue(0x7FB238); // Default grass green
        }
    }

    @Inject(method = "getFoliageColor", at = @At("HEAD"), cancellable = true)
    private void vulkanmodExtra$controlFoliageColors(CallbackInfoReturnable<Integer> cir) {
        var clientConfig = VulkanModExtraClientConfig.getInstance();

        // Check if biome colors are disabled
        if (!clientConfig.detailSettings.biomeColors) {
            // Return a default foliage color
            cir.setReturnValue(0x59AE30); // Default foliage green
        }
    }

    @Inject(method = "getWaterColor", at = @At("HEAD"), cancellable = true)
    private void vulkanmodExtra$controlWaterColors(CallbackInfoReturnable<Integer> cir) {
        var clientConfig = VulkanModExtraClientConfig.getInstance();

        // Check if biome colors are disabled
        if (!clientConfig.detailSettings.biomeColors) {
            // Return a default water color
            cir.setReturnValue(0x3F76E4); // Default water blue
        }
    }
}
