package com.criticalrange.mixin.block_rendering;

import com.criticalrange.client.config.VulkanModExtraClientConfig;
import net.minecraft.class_835;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * Controls piston rendering based on configuration
 */
@Mixin(class_835.class)
public class MixinPistonRenderer {

    @Inject(method = "render*", at = @At("HEAD"), cancellable = true)
    private void onRender(CallbackInfo ci) {
        if (!VulkanModExtraClientConfig.getInstance().renderSettings.piston) {
            ci.cancel();
        }
    }
}