package com.criticalrange.mixin.client;

import com.criticalrange.client.VulkanModExtraClientMod;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * Mixin to hook into Minecraft's GUI rendering system
 * This allows us to render VulkanMod Extra HUD elements
 */
@Mixin(class_329.class)
public class MixinGui {
    @Inject(method = "render", at = @At("TAIL"))
    private void vulkanmodExtra$onRender(class_332 guiGraphics, class_9779 deltaTracker, CallbackInfo ci) {
        VulkanModExtraClientMod.onHudRender(guiGraphics, deltaTracker.method_60637(false));
    }
}
