package com.criticalrange.mixin.entity_rendering;

import com.criticalrange.client.config.VulkanModExtraClientConfig;
import net.minecraft.class_915;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * Controls item frame rendering based on configuration
 */
@Mixin(class_915.class)
public class MixinItemFrameRenderer {

    @Inject(method = "render*", at = @At("HEAD"), cancellable = true)
    private void onRender(CallbackInfo ci) {
        if (!VulkanModExtraClientConfig.getInstance().renderSettings.itemFrame) {
            ci.cancel();
        }
    }
}