package com.criticalrange.mixin.entity_rendering;

import com.criticalrange.client.config.VulkanModExtraClientConfig;
import net.minecraft.class_928;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * Controls painting rendering based on configuration
 */
@Mixin(class_928.class)
public class MixinPaintingRenderer {

    @Inject(method = "render*", at = @At("HEAD"), cancellable = true)
    private void onRender(CallbackInfo ci) {
        if (!VulkanModExtraClientConfig.getInstance().renderSettings.painting) {
            ci.cancel();
        }
    }
}