package com.criticalrange.mixin.optimizations.beacon_beam_rendering;

import com.criticalrange.client.config.VulkanModExtraClientConfig;
import net.minecraft.class_2580;
import net.minecraft.class_822;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * Beacon beam rendering optimization mixin
 * Controls beacon beam rendering and height limiting
 */
@Mixin(class_822.class)
public class MixinBeaconRenderer {

    @Inject(method = "render", at = @At("HEAD"), cancellable = true)
    private void vulkanmodExtra$checkBeaconRendering(class_2580 beaconBlockEntity, float partialTick, 
            net.minecraft.class_4587 poseStack, net.minecraft.class_4597 multiBufferSource, 
            int packedLight, int packedOverlay, CallbackInfo ci) {
        // Cancel beacon beam rendering if disabled
        if (!VulkanModExtraClientConfig.getInstance().renderSettings.beaconBeam) {
            ci.cancel();
        }
    }

    // Note: Beacon height limiting would require more complex mixin targeting
    // For now, we'll focus on the beacon beam toggle functionality
}
