package com.criticalrange.mixin.particle;

import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_702;
import net.minecraft.class_703;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

/**
 * Performance-focused particle optimization mixin
 * Reduces expensive particle effects for better performance
 */
@Mixin(class_702.class)
public class MixinParticleEngine {

    // Performance optimization - reduce particle processing overhead
    @Inject(method = "tick", at = @At("HEAD"))
    private void vulkanmodExtra$optimizeParticleTicks(CallbackInfo ci) {
        // Framework for particle tick optimizations
        // Could implement particle batching, culling, or lifecycle optimizations
    }

    // Add particle creation control using config settings
    @Inject(method = "createParticle", at = @At("HEAD"), cancellable = true)
    private void vulkanmodExtra$controlParticleCreation(class_2394 particleOptions, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, CallbackInfoReturnable<class_703> cir) {
        // Check if particles are enabled in config
        if (!com.criticalrange.VulkanModExtra.CONFIG.particleSettings.particles) {
            cir.setReturnValue(null);
            return;
        }

        // Check specific particle type settings
        if (shouldDisableParticle(particleOptions)) {
            cir.setReturnValue(null);
            return;
        }
    }

    private boolean shouldDisableParticle(class_2394 particleOptions) {
        // Check config settings for specific particle types
        if (particleOptions.method_10295() == class_2398.field_11240 && !com.criticalrange.VulkanModExtra.CONFIG.particleSettings.flame) {
            return true;
        }
        if (particleOptions.method_10295() == class_2398.field_11251 && !com.criticalrange.VulkanModExtra.CONFIG.particleSettings.smoke) {
            return true;
        }
        if ((particleOptions.method_10295() == class_2398.field_17430 || particleOptions.method_10295() == class_2398.field_17431)
            && !com.criticalrange.VulkanModExtra.CONFIG.particleSettings.campfireCosySmoke) {
            return true;
        }
        if (particleOptions.method_10295() == class_2398.field_11247 && !com.criticalrange.VulkanModExtra.CONFIG.particleSettings.bubble) {
            return true;
        }
        if (particleOptions.method_10295() == class_2398.field_11202 && !com.criticalrange.VulkanModExtra.CONFIG.particleSettings.splash) {
            return true;
        }
        if (particleOptions.method_10295() == class_2398.field_11242 && !com.criticalrange.VulkanModExtra.CONFIG.particleSettings.rain) {
            return true;
        }
        if (particleOptions.method_10295() == class_2398.field_11232 && !com.criticalrange.VulkanModExtra.CONFIG.particleSettings.drippingWater) {
            return true;
        }
        return false;
    }


}
