package com.criticalrange.mixin.prevent_shaders;

import com.criticalrange.VulkanModExtra;
import net.minecraft.class_757;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * Shader prevention optimization mixin
 * Prevents shader loading for better performance and faster world loading
 * Implementation based on proven Sodium Extra pattern
 */
@Mixin(class_757.class)
public class MixinGameRenderer {

    @Inject(method = "togglePostEffect", at = @At("HEAD"), cancellable = true)
    private void vulkanmodExtra$preventShaderToggle(CallbackInfo ci) {
        if (VulkanModExtra.CONFIG.extraSettings.preventShaders) {
            ci.cancel();
        }
    }
}
