/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields;

import com.mojang.logging.LogUtils;
import net.alminoris.wildfields.Config;
import net.alminoris.wildfields.block.ModBlocks;
import net.alminoris.wildfields.block.entity.ModBlockEntities;
import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.entity.client.AnimalGeoRenderer;
import net.alminoris.wildfields.entity.client.ModBoatRenderer;
import net.alminoris.wildfields.entity.client.projectile.SteppeArrowRenderer;
import net.alminoris.wildfields.item.ModItemGroups;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.particle.ModParticles;
import net.alminoris.wildfields.sound.ModSounds;
import net.alminoris.wildfields.util.helper.ModBlockSetsHelper;
import net.alminoris.wildfields.world.biome.ModTerrablenderAPI;
import net.alminoris.wildfields.world.gen.decorator.ModTreeDecorators;
import net.alminoris.wildfields.world.gen.features.ModFeatures;
import net.alminoris.wildfields.world.tree.ModFoliagePlacerTypes;
import net.alminoris.wildfields.world.tree.ModTrunkPlacerTypes;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="wildfields")
public class WildFields {
    public static final String MOD_ID = "wildfields";
    private static final Logger LOGGER = LogUtils.getLogger();

    public WildFields(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModParticles.register(modEventBus);
        ModSounds.register(modEventBus);
        ModItemGroups.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModEntities.register(modEventBus);
        ModFeatures.register(modEventBus);
        ModTreeDecorators.register(modEventBus);
        ModTrunkPlacerTypes.register(modEventBus);
        ModFoliagePlacerTypes.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Config.items.forEach(item -> LOGGER.info("ITEM >> {}", (Object)item.toString()));
        event.enqueueWork(() -> ModTerrablenderAPI.registerBiomes());
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(modid="wildfields", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            for (String name : ModBlockSetsHelper.WOOD_NAMES) {
                Sheets.addWoodType((WoodType)ModBlockSetsHelper.WOOD_TYPES.get(name));
            }
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.MOD_BOAT.get()), pContext -> new ModBoatRenderer(pContext, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.MOD_CHEST_BOAT.get()), pContext -> new ModBoatRenderer(pContext, true));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SAIGA.get()), context -> new AnimalGeoRenderer(context, 1.2f, 0.8f, true, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SERVAL.get()), context -> new AnimalGeoRenderer(context, 1.0f, 0.6f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.DARKLING_BEETLE.get()), context -> new AnimalGeoRenderer(context, 1.0f, 0.4f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.STEPPE_VIPER.get()), context -> new AnimalGeoRenderer(context, 1.0f, 0.6f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.STEPPE_EAGLE.get()), context -> new AnimalGeoRenderer(context, 1.0f, 0.6f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.MARMOT.get()), context -> new AnimalGeoRenderer(context, 1.2f, 0.6f, false, true));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.MOLE.get()), context -> new AnimalGeoRenderer(context, 0.75f, 0.35f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.COYOTE.get()), context -> new AnimalGeoRenderer(context, 1.0f, 0.6f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BISON.get()), context -> new AnimalGeoRenderer(context, 1.0f, 0.6f, true, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.FERRUGINOUS_HAWK.get()), context -> new AnimalGeoRenderer(context, 1.0f, 0.6f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.WHITE_TAILED_JACKRABBIT.get()), context -> new AnimalGeoRenderer(context, 0.75f, 0.4f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.PALLID_WINGED_GRASSHOPPER.get()), context -> new AnimalGeoRenderer(context, 0.6f, 0.35f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BLACK_BILLED_MAGPIE.get()), context -> new AnimalGeoRenderer(context, 0.8f, 0.45f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.WESTERN_MEADOWLARK.get()), context -> new AnimalGeoRenderer(context, 0.8f, 0.45f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.STEPPE_ARROW.get()), SteppeArrowRenderer::new);
            event.enqueueWork(() -> {
                for (String name : ModBlockSetsHelper.WOOD_NAMES) {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlockSetsHelper.WOODEN_DOORS.get(name).get()), (RenderType)RenderType.m_110463_());
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlockSetsHelper.WOODEN_TRAPDOORS.get(name).get()), (RenderType)RenderType.m_110463_());
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlockSetsHelper.WOODEN_SAPLINGS.get(name).get()), (RenderType)RenderType.m_110463_());
                }
                for (String name : ModBlockSetsHelper.BUSHES_NAMES) {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlockSetsHelper.BUSHES.get(name).get()), (RenderType)RenderType.m_110463_());
                }
                for (String name : ModBlockSetsHelper.WILD_CROP_NAMES) {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlockSetsHelper.WILD_CROPS.get(name).get()), (RenderType)RenderType.m_110463_());
                }
                for (String name : ModBlockSetsHelper.CROP_NAMES) {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlockSetsHelper.HAY_BLOCKS.get(name).get()), (RenderType)RenderType.m_110463_());
                }
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GREEN_LICHEN.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.FEATHER_GRASS.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.THYME.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SPIDER_MILKWEED.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WORMWOOD.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.BLUE_GRAMA_GRASS.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.PRAIRIE_SAGE.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.PRAIRIE_ROSE.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SMOOTH_ASTER.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.VIOLA.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.TINY_GRASS.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.COTTONWOOD_FLUFF.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.COTTONWOOD_FLUFF.get()), (RenderType)RenderType.m_110466_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SERVAL_HIDE.get()), (RenderType)RenderType.m_110463_());
            });
        }
    }
}

