/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.alminoris.wildfields.entity.client.AnimalGeoModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class AnimalGeoRenderer<T extends Animal>
extends GeoEntityRenderer<T> {
    private final ItemRenderer itemRenderer;
    private final float scale;
    private final float babyScale;
    private final boolean hasHorns;
    private final boolean hasItemRenderer;

    public AnimalGeoRenderer(EntityRendererProvider.Context renderManager, float scale, float babyScale, boolean hasHorns, boolean hasItemRenderer) {
        super(renderManager, new AnimalGeoModel());
        this.itemRenderer = renderManager.m_174025_();
        this.scale = scale;
        this.babyScale = babyScale;
        this.hasHorns = hasHorns;
        this.hasItemRenderer = hasItemRenderer;
    }

    protected String resolveName(T animatable) {
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)animatable.m_6095_());
        if (key != null) {
            return key.m_135815_();
        }
        return animatable.m_20078_();
    }

    public ResourceLocation getTextureLocation(T animatable) {
        String name = this.resolveName(animatable);
        return ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)("textures/entity/" + name + ".png"));
    }

    public void postRender(PoseStack poseStack, T animatable, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.hasItemRenderer) {
            this.renderHeldItem(animatable, poseStack, bufferSource, packedLight);
        }
        super.postRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (animatable.m_6162_()) {
            poseStack.m_85841_(this.babyScale, this.babyScale, this.babyScale);
            if (this.hasHorns) {
                ((GeoBone)model.getBone("horn1").get()).setHidden(true);
                ((GeoBone)model.getBone("horn2").get()).setHidden(true);
            }
        } else {
            poseStack.m_85841_(this.scale, this.scale, this.scale);
            if (this.hasHorns) {
                ((GeoBone)model.getBone("horn1").get()).setHidden(false);
                ((GeoBone)model.getBone("horn2").get()).setHidden(false);
            }
        }
        super.preRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    private void renderHeldItem(T entity, PoseStack matrices, MultiBufferSource bufferSource, int light) {
        ItemStack itemStack = entity.m_21120_(InteractionHand.MAIN_HAND);
        if (!itemStack.m_41619_()) {
            BakedModel model = this.itemRenderer.m_174264_(itemStack, entity.m_9236_(), entity, 0);
            matrices.m_85836_();
            matrices.m_85837_(0.0, 0.5, 0.0);
            matrices.m_85841_(0.5f, 0.5f, 0.5f);
            this.itemRenderer.m_115143_(itemStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, false, matrices, bufferSource, light, 0, model);
            matrices.m_85849_();
        }
    }
}

