/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.entity.custom;

import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.sound.ModSounds;
import net.alminoris.wildfields.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class BisonEntity
extends Animal
implements GeoEntity {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> DATA_EATING = SynchedEntityData.m_135353_(BisonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int EAT_DURATION = 200;
    private static int globalEatInterval = 3600;
    private int eatingTimer = globalEatInterval;

    public BisonEntity(EntityType<? extends BisonEntity> type, Level level) {
        super(type, level);
        this.f_21342_ = new MoveControl((Mob)this);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22283_, 0.75);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 0.85));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 0.8, Ingredient.m_204132_(ModTags.Items.BISON_FOOD), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 0.75));
        this.f_21345_.m_25352_(5, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.75));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 7.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_EATING, (Object)false);
    }

    public boolean isEating() {
        return (Boolean)this.f_19804_.m_135370_(DATA_EATING);
    }

    public void setEating(boolean eating) {
        this.f_19804_.m_135381_(DATA_EATING, (Object)eating);
        this.m_20124_(eating ? Pose.SITTING : Pose.STANDING);
        if (eating) {
            this.m_21573_().m_26573_();
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsEating", this.isEating());
        compound.m_128405_("EatingTimer", this.eatingTimer);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("IsEating")) {
            this.setEating(compound.m_128471_("IsEating"));
        }
        if (compound.m_128441_("EatingTimer")) {
            this.eatingTimer = compound.m_128451_("EatingTimer");
        }
    }

    protected void m_7625_(DamageSource pSource, boolean pRecentlyHit) {
        int count;
        super.m_7625_(pSource, pRecentlyHit);
        RandomSource rnd = this.m_9236_().f_46441_;
        if (rnd.m_188501_() < 0.05f && (count = rnd.m_188503_(2)) > 0) {
            this.m_20000_((ItemLike)ModItems.BISON_HORN.get(), count);
        }
        if (rnd.m_188501_() < 0.5f && (count = rnd.m_188503_(5)) > 0) {
            this.m_20000_((ItemLike)ModItems.BISON.get(), count);
        }
        if (rnd.m_188501_() < 0.25f && (count = rnd.m_188503_(7)) > 0) {
            this.m_20000_((ItemLike)Items.f_42454_, count);
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.SOUND_BISON_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource dmg) {
        return (SoundEvent)ModSounds.SOUND_BISON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SOUND_BISON_DEATH.get();
    }

    @Nullable
    public BisonEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageable) {
        EntityType type = (EntityType)ModEntities.BISON.get();
        Entity entity = type.m_20615_((Level)serverLevel);
        if (entity instanceof BisonEntity) {
            return (BisonEntity)entity;
        }
        return null;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(ModTags.Items.BISON_FOOD);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (globalEatInterval <= 0) {
                globalEatInterval = 3600 + this.f_19796_.m_188503_(2401);
            }
            if (!this.isEating() && this.eatingTimer > 0) {
                --this.eatingTimer;
            } else if (!this.isEating() && this.eatingTimer <= 0) {
                this.setEating(true);
                this.eatingTimer = 200;
            }
            if (this.isEating() && this.eatingTimer > 0) {
                --this.eatingTimer;
            } else if (this.isEating() && this.eatingTimer <= 0) {
                this.setEating(false);
                this.eatingTimer = globalEatInterval = 3600 + this.f_19796_.m_188503_(2401);
            }
            if (this.isEating() && this.m_20069_()) {
                this.setEating(false);
                this.eatingTimer = globalEatInterval = 3600 + this.f_19796_.m_188503_(2401);
            }
        }
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.isEating()) {
            this.m_20256_(Vec3.f_82478_);
            return;
        }
        super.m_7023_(pTravelVector);
    }

    public boolean m_6573_(Player p_21418_) {
        return true;
    }

    public static <T extends Animal> boolean isValidNaturalSpawn(EntityType<T> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        boolean lightOk = Mob.m_217057_(type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
        boolean isSpawnableBlock = world.m_8055_(pos.m_7495_()).m_204336_(ModTags.Blocks.BISON_SPAWNABLE_ON);
        return lightOk && isSpawnableBlock;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        if (this.m_6898_(item)) {
            return super.m_6071_(player, hand);
        }
        return InteractionResult.PASS;
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (pose == Pose.SITTING) {
            return EntityDimensions.m_20395_((float)this.m_6095_().m_20678_(), (float)(this.m_6095_().m_20679_() - 0.5f));
        }
        return super.m_6972_(pose);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            if (this.m_5912_()) {
                return state.setAndContinue(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
            }
            if (this.isEating()) {
                return state.setAndContinue(RawAnimation.begin().then("eating", Animation.LoopType.PLAY_ONCE));
            }
            if (state.isMoving()) {
                return state.setAndContinue(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
            }
            return state.setAndContinue(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int m_5792_() {
        return 7;
    }
}

