/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.entity.custom;

import java.util.function.Predicate;
import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.sound.ModSounds;
import net.alminoris.wildfields.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class SaigaEntity
extends Animal
implements GeoEntity {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final int EAT_DURATION = 200;
    private static int eatInterval = 3600;
    private int eatingTimer = eatInterval;
    private static final EntityDataAccessor<Boolean> IS_EATING = SynchedEntityData.m_135353_(SaigaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final Predicate<LivingEntity> BABY_SAIGA = LivingEntity::m_6162_;

    public SaigaEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_7625_(DamageSource damageSource, boolean causedByPlayer) {
        super.m_7625_(damageSource, causedByPlayer);
        if (this.f_19796_.m_188501_() < 0.05f) {
            this.m_19983_(new ItemStack((ItemLike)ModItems.SAIGA_HORN.get(), this.f_19796_.m_188503_(2)));
        }
        if (this.f_19796_.m_188501_() < 0.5f) {
            this.m_19983_(new ItemStack((ItemLike)ModItems.SAIGA.get(), this.f_19796_.m_188503_(5)));
        }
        if (this.f_19796_.m_188501_() < 0.25f) {
            this.m_19983_(new ItemStack((ItemLike)Items.f_42454_, this.f_19796_.m_188503_(3)));
        }
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 0.85));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 0.8, Ingredient.m_204132_(ModTags.Items.SAIGA_FOOD), false));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 0.75));
        this.f_21345_.m_25352_(4, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 7.0f));
        super.m_8099_();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.SOUND_SAIGA_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ModSounds.SOUND_SAIGA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SOUND_SAIGA_DEATH.get();
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(ModTags.Items.SAIGA_FOOD);
    }

    @Nullable
    public SaigaEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageable) {
        EntityType type = (EntityType)ModEntities.SAIGA.get();
        Entity entity = type.m_20615_((Level)serverLevel);
        if (entity instanceof SaigaEntity) {
            return (SaigaEntity)entity;
        }
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_EATING, (Object)false);
    }

    public boolean isEating() {
        return (Boolean)this.f_19804_.m_135370_(IS_EATING);
    }

    public void setEating(boolean sitting) {
        this.f_19804_.m_135381_(IS_EATING, (Object)sitting);
        this.m_20124_(sitting ? Pose.SITTING : Pose.STANDING);
        if (sitting) {
            this.m_21573_().m_26573_();
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsEating", this.isEating());
        compound.m_128405_("EatingTimer", this.eatingTimer);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("IsEating")) {
            this.setEating(compound.m_128471_("IsEating"));
        }
        if (compound.m_128441_("EatingTimer")) {
            this.eatingTimer = compound.m_128451_("EatingTimer");
        }
    }

    public void m_7023_(Vec3 movementInput) {
        if (this.isEating()) {
            this.m_20256_(Vec3.f_82478_);
            return;
        }
        super.m_7023_(movementInput);
    }

    public void m_8107_() {
        if (this.isEating()) {
            this.f_20883_ = this.f_20884_;
            return;
        }
        super.m_8107_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            eatInterval = 3600 + this.f_19796_.m_188503_(2401);
            if (!this.isEating() && this.eatingTimer > 0) {
                --this.eatingTimer;
            } else if (!this.isEating() && this.eatingTimer <= 0) {
                this.setEating(true);
                this.eatingTimer = 200;
            }
            if (this.isEating() && this.eatingTimer > 0) {
                --this.eatingTimer;
            } else if (this.isEating() && this.eatingTimer <= 0) {
                this.setEating(false);
                this.eatingTimer = eatInterval;
            }
            if (this.isEating() && this.m_20069_()) {
                this.setEating(false);
                this.eatingTimer = eatInterval;
            }
        }
    }

    public static <T extends Animal> boolean isValidNaturalSpawn(EntityType<T> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        boolean lightOk = Mob.m_217057_(type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
        boolean isSpawnableBlock = world.m_8055_(pos.m_7495_()).m_204336_(ModTags.Blocks.SAIGA_SPAWNABLE_ON);
        return lightOk && isSpawnableBlock;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            if (this.isEating()) {
                return state.setAndContinue(RawAnimation.begin().then("eating", Animation.LoopType.PLAY_ONCE));
            }
            if (state.isMoving()) {
                return state.setAndContinue(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
            }
            return state.setAndContinue(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        })});
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (pose == Pose.SITTING) {
            return EntityDimensions.m_20395_((float)this.m_6095_().m_20678_(), (float)(this.m_6095_().m_20679_() - 0.5f));
        }
        return super.m_6972_(pose);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int m_5792_() {
        return 7;
    }
}

