/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.entity.custom;

import java.util.UUID;
import java.util.function.Predicate;
import net.alminoris.wildfields.block.ModBlocks;
import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.entity.custom.SaigaEntity;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.sound.ModSounds;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class ServalEntity
extends TamableAnimal
implements GeoEntity,
NeutralMob {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> DATA_ANGER_TIME = SynchedEntityData.m_135353_(ServalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Predicate<LivingEntity> FOLLOW_TAMED_PREDICATE = entity -> {
        EntityType entityType = entity.m_6095_();
        return entityType == ModEntities.MARMOT.get() || entityType == EntityType.f_20517_ || entityType == ModEntities.STEPPE_EAGLE.get() || entityType == EntityType.f_20520_;
    };
    private static final int ANGER_MIN = 400;
    private static final int ANGER_MAX = 780;
    @Nullable
    private UUID angryAt;

    public ServalEntity(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.m_7105_(false);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22283_, 1.5).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 4.5);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.7f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::m_21674_));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, FOLLOW_TAMED_PREDICATE));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.f_30122_));
        this.f_21346_.m_25352_(7, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, SaigaEntity.class, false, SaigaEntity.BABY_SAIGA));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ANGER_TIME, (Object)0);
    }

    public boolean hasAngerTime() {
        return this.m_6784_() > 0;
    }

    protected SoundEvent m_7515_() {
        if (this.hasAngerTime()) {
            return (SoundEvent)ModSounds.SOUND_SERVAL_GROWL.get();
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            return this.m_21824_() && this.m_21223_() < 20.0f ? (SoundEvent)ModSounds.SOUND_SERVAL_WHINE.get() : (SoundEvent)ModSounds.SOUND_SERVAL_AMBIENT.get();
        }
        return (SoundEvent)ModSounds.SOUND_SERVAL_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ModSounds.SOUND_SERVAL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SOUND_SERVAL_DEATH.get();
    }

    protected float m_6121_() {
        return 0.5f;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_((Item)ModItems.SAIGA.get());
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mate) {
        ServalEntity child = (ServalEntity)((EntityType)ModEntities.SERVAL.get()).m_20615_((Level)level);
        if (child != null && mate instanceof ServalEntity) {
            ServalEntity mateServal = (ServalEntity)mate;
            if (this.m_21824_()) {
                child.m_21816_(this.m_21805_());
                child.m_7105_(true);
            }
        }
        return child;
    }

    public boolean m_7848_(Animal other) {
        if (!(other instanceof ServalEntity)) {
            return false;
        }
        ServalEntity otherServal = (ServalEntity)other;
        return this.m_21824_() && otherServal.m_21824_() && this.m_27593_() && otherServal.m_27593_();
    }

    protected void m_7625_(DamageSource source, boolean causedByPlayer) {
        super.m_7625_(source, causedByPlayer);
        if (this.f_19796_.m_188501_() < 0.2f) {
            this.m_19998_((ItemLike)ModBlocks.SERVAL_HIDE.get());
        }
    }

    public void m_8107_() {
        if (this.m_5803_()) {
            this.f_20883_ = this.f_20884_;
            return;
        }
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_ANGER_TIME);
    }

    public void m_7870_(int time) {
        this.f_19804_.m_135381_(DATA_ANGER_TIME, (Object)time);
    }

    @Nullable
    public UUID getAngryAt() {
        return this.angryAt;
    }

    public boolean m_21674_(LivingEntity p_21675_) {
        return super.m_21674_(p_21675_);
    }

    public void m_6925_(@Nullable UUID uuid) {
        this.angryAt = uuid;
    }

    @Nullable
    public UUID m_6120_() {
        return this.angryAt;
    }

    public void m_6825_() {
        RandomSource random = this.m_9236_().m_213780_();
        this.m_7870_(random.m_188503_(380) + 400);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.m_9236_().f_46443_) {
            return InteractionResult.m_19078_((boolean)true);
        }
        if (this.m_21824_()) {
            if (stack.m_41720_() == Items.f_42580_ && this.m_21223_() < this.m_21233_()) {
                stack.m_41774_(1);
                this.m_5634_(2.0f);
                return InteractionResult.SUCCESS;
            }
            if (player.equals((Object)this.m_269323_())) {
                this.m_21839_(!this.m_21827_());
                this.f_21344_.m_26573_();
                return InteractionResult.SUCCESS;
            }
        } else if (stack.m_41720_() == ModItems.SAIGA.get() && !this.hasAngerTime()) {
            stack.m_41774_(1);
            if (this.f_19796_.m_188503_(3) == 0) {
                this.m_21828_(player);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            if (this.m_21827_()) {
                return state.setAndContinue(RawAnimation.begin().then("sit", Animation.LoopType.HOLD_ON_LAST_FRAME));
            }
            if (this.m_5912_()) {
                return state.setAndContinue(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
            }
            if (state.isMoving()) {
                return state.setAndContinue(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
            }
            return state.setAndContinue(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, 0.6 * (double)this.m_20192_(), (double)this.m_20205_() * 0.4);
    }

    public boolean m_6573_(Player player) {
        return !this.hasAngerTime();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21839_(false);
        }
        return super.m_6469_(source, amount);
    }

    public int m_5792_() {
        return 3;
    }
}

