/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.entity.custom;

import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.entity.custom.MarmotEntity;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class SteppeEagleEntity
extends Animal
implements GeoEntity,
FlyingAnimal {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int featherDropCooldown = 1200;

    public SteppeEagleEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
    }

    protected PathNavigation m_6037_(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, world);
        birdNavigation.m_26443_(false);
        birdNavigation.m_7008_(false);
        birdNavigation.m_26440_(true);
        return birdNavigation;
    }

    protected void m_7840_(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_7625_(DamageSource damageSource, boolean causedByPlayer) {
        super.m_7625_(damageSource, causedByPlayer);
        if (this.f_19796_.m_188501_() < 0.05f) {
            this.m_19983_(new ItemStack((ItemLike)ModItems.STEPPE_EAGLE_BEAK.get(), 1));
        }
        if (this.f_19796_.m_188501_() < 0.25f) {
            this.m_19983_(new ItemStack((ItemLike)ModItems.STEPPE_EAGLE_FEATHER.get(), 1));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && !this.m_6162_() && this.featherDropCooldown-- <= 0) {
            this.dropFeather();
            this.featherDropCooldown = 3600 + this.f_19796_.m_188503_(2400);
        }
    }

    private void dropFeather() {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ModItems.STEPPE_EAGLE_FEATHER.get())));
        }
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22281_, 4.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new HighAltitudeWanderGoal((PathfinderMob)this, 1.0, 200, 80, 0.05f));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 5.0f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, MarmotEntity.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, true));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        super.m_8099_();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.SOUND_STEPPE_EAGLE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ModSounds.SOUND_STEPPE_EAGLE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SOUND_STEPPE_EAGLE_DEATH.get();
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42648_);
    }

    @Nullable
    public SteppeEagleEntity getBreedOffspring(ServerLevel level, AgeableMob mate) {
        Entity entity = ((EntityType)ModEntities.STEPPE_EAGLE.get()).m_20615_((Level)level);
        if (entity instanceof SteppeEagleEntity) {
            return (SteppeEagleEntity)entity;
        }
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            if (this.m_5912_()) {
                return state.setAndContinue(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
            }
            if (this.m_29443_()) {
                return state.setAndContinue(RawAnimation.begin().then("flying", Animation.LoopType.LOOP));
            }
            return state.setAndContinue(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    public Vec3 m_245894_(float p_249286_) {
        return new Vec3(0.0, (double)(0.5f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    static class HighAltitudeWanderGoal
    extends Goal {
        private final PathfinderMob mob;
        private final double speed;
        private final int maxHeight;
        private final int minHeight;
        private final float chance;
        private Vec3 target;
        private boolean descending = false;

        public HighAltitudeWanderGoal(PathfinderMob mob, double speed, int maxHeight, int minHeight, float chance) {
            this.mob = mob;
            this.speed = speed;
            this.maxHeight = maxHeight;
            this.minHeight = minHeight;
            this.chance = chance;
        }

        public boolean m_8036_() {
            if (this.mob.m_21573_().m_26571_() && this.mob.m_217043_().m_188501_() < this.chance) {
                if (this.descending) {
                    this.target = this.findGroundTarget();
                    return this.target != null;
                }
                Level world = this.mob.m_9236_();
                double x = this.mob.m_20185_() + this.mob.m_217043_().m_188583_() * 20.0;
                double z = this.mob.m_20189_() + this.mob.m_217043_().m_188583_() * 20.0;
                double y = Math.min(Math.max((double)this.minHeight, this.mob.m_20186_() + this.mob.m_217043_().m_188583_() * 10.0), (double)this.maxHeight);
                this.target = new Vec3(x, y, z);
                return true;
            }
            return false;
        }

        public void m_8056_() {
            if (this.target != null) {
                this.mob.m_21573_().m_26519_(this.target.f_82479_, this.target.f_82480_, this.target.f_82481_, this.speed);
            }
        }

        public boolean m_8045_() {
            if (this.descending) {
                return !this.mob.m_21573_().m_26571_() && this.mob.m_20186_() > (double)this.mob.m_9236_().m_141937_();
            }
            return !this.mob.m_21573_().m_26571_() && this.target != null;
        }

        public void m_8041_() {
            this.descending = !this.descending && this.mob.m_20186_() >= (double)(this.maxHeight - 5);
            this.target = null;
        }

        private Vec3 findGroundTarget() {
            Level world = this.mob.m_9236_();
            RandomSource random = this.mob.m_217043_();
            BlockPos groundPos = new BlockPos((int)(this.mob.m_20185_() + random.m_188583_() * 20.0), (int)this.mob.m_20186_(), (int)(this.mob.m_20189_() + random.m_188583_() * 20.0));
            if (world.m_8055_(groundPos = world.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, groundPos)).m_60795_()) {
                return Vec3.m_82539_((Vec3i)groundPos);
            }
            return null;
        }
    }
}

