/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.entity.custom;

import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class WhiteTailedJackrabbitEntity
extends Animal
implements GeoEntity {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int jumpTicks;
    private int jumpDuration;
    private boolean lastOnGround;
    private int ticksUntilJump;
    int moreBeetrootTicks;

    public WhiteTailedJackrabbitEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.f_21343_ = new WhiteTailedJackrabbitJumpControl(this);
        this.f_21342_ = new WhiteTailedJackrabbitMoveControl(this);
        this.setSpeed(0.0);
    }

    protected void m_7625_(DamageSource damageSource, boolean causedByPlayer) {
        super.m_7625_(damageSource, causedByPlayer);
        this.m_19983_(new ItemStack((ItemLike)ModItems.JACKRABBIT.get(), 1));
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22284_, 1.5);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new EatBeetrootCropGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 0.85));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 0.8, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42732_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 0.75));
        this.f_21345_.m_25352_(5, (Goal)new EscapeDangerGoal(this, 1.5));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        super.m_8099_();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.SOUND_WHITE_TAILED_JACKRABBIT_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ModSounds.SOUND_WHITE_TAILED_JACKRABBIT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SOUND_WHITE_TAILED_JACKRABBIT_DEATH.get();
    }

    @Nullable
    public WhiteTailedJackrabbitEntity getBreedOffspring(ServerLevel level, AgeableMob mate) {
        Entity entity = ((EntityType)ModEntities.WHITE_TAILED_JACKRABBIT.get()).m_20615_((Level)level);
        if (entity instanceof WhiteTailedJackrabbitEntity) {
            return (WhiteTailedJackrabbitEntity)entity;
        }
        return null;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42732_);
    }

    public static <T extends Animal> boolean isValidNaturalSpawn(EntityType<T> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        boolean lightOk = Mob.m_217057_(type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
        boolean isSpawnableBlock = world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184234_);
        return lightOk && isSpawnableBlock;
    }

    protected float m_6118_() {
        Path path;
        float f = 0.35f;
        if (this.f_19862_ || this.f_21342_.m_24995_() && this.f_21342_.m_25001_() > this.m_20186_() + 0.5) {
            f = 0.6f;
        }
        if ((path = this.f_21344_.m_26570_()) != null && !path.m_77392_()) {
            Vec3 vec3d = path.m_77380_((Entity)this);
            if (vec3d.f_82480_ > this.m_20186_() + 0.5) {
                f = 0.6f;
            }
        }
        if (this.f_21342_.m_24999_() <= 0.6) {
            f = 0.25f;
        }
        return super.m_6118_();
    }

    public void m_6135_() {
        double e;
        super.m_6135_();
        double d = this.f_21342_.m_24999_();
        if (d > 0.0 && (e = this.m_20184_().m_165925_()) < 0.01) {
            this.m_19920_(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)1);
        }
    }

    public void setSpeed(double speed) {
        this.m_21573_().m_26517_(speed);
        this.f_21342_.m_6849_(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_(), speed);
    }

    public void m_6862_(boolean jumping) {
        super.m_6862_(jumping);
        if (jumping) {
            this.m_5496_(this.getJumpSound(), this.m_6121_(), ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJump() {
        this.m_6862_(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    public void m_8024_() {
        if (this.ticksUntilJump > 0) {
            --this.ticksUntilJump;
        }
        if (this.moreBeetrootTicks > 0) {
            this.moreBeetrootTicks -= this.f_19796_.m_188503_(3);
            if (this.moreBeetrootTicks < 0) {
                this.moreBeetrootTicks = 0;
            }
        }
        if (this.m_20096_()) {
            WhiteTailedJackrabbitJumpControl rabbitJumpControl;
            if (!this.lastOnGround) {
                this.m_6862_(false);
                this.scheduleJump();
            }
            if (!(rabbitJumpControl = (WhiteTailedJackrabbitJumpControl)this.f_21343_).isActive()) {
                if (this.f_21342_.m_24995_() && this.ticksUntilJump == 0) {
                    Path path = this.f_21344_.m_26570_();
                    Vec3 vec3d = new Vec3(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_());
                    if (path != null && !path.m_77392_()) {
                        vec3d = path.m_77380_((Entity)this);
                    }
                    this.lookTowards(vec3d.f_82479_, vec3d.f_82481_);
                    this.startJump();
                }
            } else if (!rabbitJumpControl.canJump()) {
                this.enableJump();
            }
        }
        this.lastOnGround = this.m_20096_();
    }

    public boolean m_5843_() {
        return false;
    }

    private void lookTowards(double x, double z) {
        this.m_146922_((float)(Mth.m_14136_((double)(z - this.m_20189_()), (double)(x - this.m_20185_())) * 180.0 / 3.1415927410125732) - 90.0f);
    }

    private void enableJump() {
        ((WhiteTailedJackrabbitJumpControl)this.f_21343_).setCanJump(true);
    }

    private void disableJump() {
        ((WhiteTailedJackrabbitJumpControl)this.f_21343_).setCanJump(false);
    }

    private void doScheduleJump() {
        this.ticksUntilJump = this.f_21342_.m_24999_() < 2.2 ? 10 : 1;
    }

    private void scheduleJump() {
        this.doScheduleJump();
        this.disableJump();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.m_6862_(false);
        }
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.f_12354_;
    }

    boolean wantsBeetroots() {
        return this.moreBeetrootTicks <= 0;
    }

    public void m_7822_(byte status) {
        if (status == 1) {
            this.m_20076_();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.m_7822_(status);
        }
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
            }
            return state.setAndContinue(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int m_5792_() {
        return 12;
    }

    public static class WhiteTailedJackrabbitJumpControl
    extends JumpControl {
        private final WhiteTailedJackrabbitEntity whiteTailedJackrabbitEntity;
        private boolean canJump;

        public WhiteTailedJackrabbitJumpControl(WhiteTailedJackrabbitEntity rabbit) {
            super((Mob)rabbit);
            this.whiteTailedJackrabbitEntity = rabbit;
        }

        public boolean isActive() {
            return this.f_24897_;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJump) {
            this.canJump = canJump;
        }

        public void m_8124_() {
            if (this.f_24897_) {
                this.whiteTailedJackrabbitEntity.startJump();
                this.f_24897_ = false;
            }
        }
    }

    static class WhiteTailedJackrabbitMoveControl
    extends MoveControl {
        private final WhiteTailedJackrabbitEntity whiteTailedJackrabbitEntity;
        private double whiteTailedJackrabbitSpeed;

        public WhiteTailedJackrabbitMoveControl(WhiteTailedJackrabbitEntity owner) {
            super((Mob)owner);
            this.whiteTailedJackrabbitEntity = owner;
        }

        public void m_8126_() {
            if (this.whiteTailedJackrabbitEntity.m_20096_() && !this.whiteTailedJackrabbitEntity.f_20899_ && !((WhiteTailedJackrabbitJumpControl)this.whiteTailedJackrabbitEntity.f_21343_).isActive()) {
                this.whiteTailedJackrabbitEntity.setSpeed(0.0);
            } else if (this.m_24995_()) {
                this.whiteTailedJackrabbitEntity.setSpeed(this.whiteTailedJackrabbitSpeed);
            }
            super.m_8126_();
        }

        public void m_6849_(double x, double y, double z, double speed) {
            if (this.whiteTailedJackrabbitEntity.m_20069_()) {
                speed = 1.5;
            }
            super.m_6849_(x, y, z, speed);
            if (speed > 0.0) {
                this.whiteTailedJackrabbitSpeed = speed;
            }
        }
    }

    static class EatBeetrootCropGoal
    extends MoveToBlockGoal {
        private final WhiteTailedJackrabbitEntity whiteTailedJackrabbitEntity;
        private boolean wantsBeetroots;
        private boolean hasTarget;

        public EatBeetrootCropGoal(WhiteTailedJackrabbitEntity rabbit) {
            super((PathfinderMob)rabbit, (double)0.7f, 16);
            this.whiteTailedJackrabbitEntity = rabbit;
        }

        public boolean m_8036_() {
            if (this.f_25600_ <= 0) {
                if (!ForgeEventFactory.getMobGriefingEvent((Level)this.whiteTailedJackrabbitEntity.m_9236_(), (Entity)this.whiteTailedJackrabbitEntity)) {
                    return false;
                }
                this.hasTarget = false;
                this.wantsBeetroots = this.whiteTailedJackrabbitEntity.wantsBeetroots();
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            return this.hasTarget && super.m_8045_();
        }

        public void m_8037_() {
            super.m_8037_();
            this.whiteTailedJackrabbitEntity.m_21563_().m_24950_((double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 1), (double)this.f_25602_.m_123343_() + 0.5, 10.0f, (float)this.whiteTailedJackrabbitEntity.m_8132_());
            if (this.m_25625_()) {
                Level world = this.whiteTailedJackrabbitEntity.m_9236_();
                BlockPos blockPos = this.f_25602_.m_7494_();
                BlockState blockState = world.m_8055_(blockPos);
                Block block = blockState.m_60734_();
                if (this.hasTarget && block instanceof BeetrootBlock) {
                    int i = (Integer)blockState.m_61143_((Property)BeetrootBlock.f_49657_);
                    if (i == 0) {
                        world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 2);
                        world.m_46953_(blockPos, true, (Entity)this.whiteTailedJackrabbitEntity);
                    } else {
                        world.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)BeetrootBlock.f_49657_, (Comparable)Integer.valueOf(i - 1)), 2);
                        world.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223717_((Entity)this.whiteTailedJackrabbitEntity));
                        world.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockState));
                    }
                    this.whiteTailedJackrabbitEntity.moreBeetrootTicks = 40;
                }
                this.hasTarget = false;
                this.f_25600_ = 10;
            }
        }

        protected boolean m_6465_(LevelReader world, BlockPos pos) {
            BlockState blockState = world.m_8055_(pos);
            if (blockState.m_60713_(Blocks.f_50093_) && this.wantsBeetroots && !this.hasTarget && (blockState = world.m_8055_(pos.m_7494_())).m_60734_() instanceof BeetrootBlock && ((BeetrootBlock)blockState.m_60734_()).m_52307_(blockState)) {
                this.hasTarget = true;
                return true;
            }
            return false;
        }
    }

    static class EscapeDangerGoal
    extends PanicGoal {
        private final WhiteTailedJackrabbitEntity whiteTailedJackrabbitEntity;

        public EscapeDangerGoal(WhiteTailedJackrabbitEntity rabbit, double speed) {
            super((PathfinderMob)rabbit, speed);
            this.whiteTailedJackrabbitEntity = rabbit;
        }

        public void m_8037_() {
            super.m_8037_();
            this.whiteTailedJackrabbitEntity.setSpeed(this.f_25685_);
        }
    }
}

