/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.item;

import java.util.function.Supplier;
import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.entity.custom.ModBoatEntity;
import net.alminoris.wildfields.item.ModArmorMaterials;
import net.alminoris.wildfields.item.ModFoodComponents;
import net.alminoris.wildfields.item.custom.EarthwormItem;
import net.alminoris.wildfields.item.custom.ModBoatItem;
import net.alminoris.wildfields.item.custom.SaigaSickle;
import net.alminoris.wildfields.item.custom.SteppeArrowItem;
import net.alminoris.wildfields.item.custom.SteppeViperDagger;
import net.alminoris.wildfields.util.helper.ModBlockSetsHelper;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"wildfields");
    public static final RegistryObject<Item> MARMOT_SPAWN_EGG = ModItems.registerItem("marmot_spawn_egg", () -> new ForgeSpawnEggItem(ModEntities.MARMOT, 9136460, 7625544, new Item.Properties()));
    public static final RegistryObject<Item> STEPPE_VIPER_SPAWN_EGG = ModItems.registerItem("steppe_viper_spawn_egg", () -> new ForgeSpawnEggItem(ModEntities.STEPPE_VIPER, 10589816, 6575425, new Item.Properties()));
    public static final RegistryObject<Item> DARKLING_BEETLE_SPAWN_EGG = ModItems.registerItem("darkling_beetle_spawn_egg", () -> new ForgeSpawnEggItem(ModEntities.DARKLING_BEETLE, 2040107, 658447, new Item.Properties()));
    public static final RegistryObject<Item> STEPPE_EAGLE_SPAWN_EGG = ModItems.registerItem("steppe_eagle_spawn_egg", () -> new ForgeSpawnEggItem(ModEntities.STEPPE_EAGLE, 6901310, 10255455, new Item.Properties()));
    public static final RegistryObject<Item> SAIGA_SPAWN_EGG = ModItems.registerItem("saiga_spawn_egg", () -> new ForgeSpawnEggItem(ModEntities.SAIGA, 16037733, 14395759, new Item.Properties()));
    public static final RegistryObject<Item> SERVAL_SPAWN_EGG = ModItems.registerItem("serval_spawn_egg", () -> new ForgeSpawnEggItem(ModEntities.SERVAL, 13868113, 5584157, new Item.Properties()));
    public static final RegistryObject<Item> MOLE_SPAWN_EGG = ModItems.registerItem("mole_spawn_egg", () -> new ForgeSpawnEggItem(ModEntities.MOLE, 0x131112, 10649729, new Item.Properties()));
    public static final RegistryObject<Item> COYOTE_SPAWN_EGG = ModItems.registerItem("coyote_spawn_egg", () -> new ForgeSpawnEggItem(ModEntities.COYOTE, 10919829, 12166531, new Item.Properties()));
    public static final RegistryObject<Item> BISON_SPAWN_EGG = ModItems.registerItem("bison_spawn_egg", () -> new ForgeSpawnEggItem(ModEntities.BISON, 3682344, 2498335, new Item.Properties()));
    public static final RegistryObject<Item> FERRUGINOUS_HAWK_SPAWN_EGG = ModItems.registerItem("ferruginous_hawk_spawn_egg", () -> new ForgeSpawnEggItem(ModEntities.FERRUGINOUS_HAWK, 9198413, 14671077, new Item.Properties()));
    public static final RegistryObject<Item> WHITE_TAILED_JACKRABBIT_SPAWN_EGG = ModItems.registerItem("white_tailed_jackrabbit_spawn_egg", () -> new ForgeSpawnEggItem(ModEntities.WHITE_TAILED_JACKRABBIT, 11776432, 0xF6F6F4, new Item.Properties()));
    public static final RegistryObject<Item> PALLID_WINGED_GRASSHOPPER_SPAWN_EGG = ModItems.registerItem("pallid_winged_grasshopper_spawn_egg", () -> new ForgeSpawnEggItem(ModEntities.PALLID_WINGED_GRASSHOPPER, 7958883, 5986384, new Item.Properties()));
    public static final RegistryObject<Item> BLACK_BILLED_MAGPIE_SPAWN_EGG = ModItems.registerItem("black_billed_magpie_spawn_egg", () -> new ForgeSpawnEggItem(ModEntities.BLACK_BILLED_MAGPIE, 1447194, 16447484, new Item.Properties()));
    public static final RegistryObject<Item> WESTERN_MEADOWLARK_SPAWN_EGG = ModItems.registerItem("western_meadowlark_spawn_egg", () -> new ForgeSpawnEggItem(ModEntities.WESTERN_MEADOWLARK, 9272926, 15515396, new Item.Properties()));
    public static final RegistryObject<Item> EARTHWORM = ModItems.registerItem("earthworm", () -> new EarthwormItem(new Item.Properties()));
    public static final RegistryObject<Item> PRAIRIES_TALISMAN = ModItems.registerItem("prairies_talisman", () -> new Item(new Item.Properties().m_41503_(500)));
    public static final RegistryObject<Item> OLIVES = ModItems.registerItem("olives", () -> new Item(new Item.Properties().m_41487_(16).m_41489_(ModFoodComponents.OLIVES)));
    public static final RegistryObject<Item> SAIGA = ModItems.registerItem("saiga", () -> new Item(new Item.Properties().m_41489_(ModFoodComponents.SAIGA)));
    public static final RegistryObject<Item> COOKED_SAIGA = ModItems.registerItem("cooked_saiga", () -> new Item(new Item.Properties().m_41489_(ModFoodComponents.COOKED_SAIGA)));
    public static final RegistryObject<Item> BISON = ModItems.registerItem("bison", () -> new Item(new Item.Properties().m_41489_(ModFoodComponents.BISON)));
    public static final RegistryObject<Item> COOKED_BISON = ModItems.registerItem("cooked_bison", () -> new Item(new Item.Properties().m_41489_(ModFoodComponents.COOKED_BISON)));
    public static final RegistryObject<Item> JACKRABBIT = ModItems.registerItem("jackrabbit", () -> new Item(new Item.Properties().m_41489_(ModFoodComponents.JACKRABBIT)));
    public static final RegistryObject<Item> COOKED_JACKRABBIT = ModItems.registerItem("cooked_jackrabbit", () -> new Item(new Item.Properties().m_41489_(ModFoodComponents.COOKED_JACKRABBIT)));
    public static final RegistryObject<Item> PALLID_WINGED_GRASSHOPPER_LEG = ModItems.registerItem("pallid_winged_grasshopper_leg", () -> new Item(new Item.Properties().m_41489_(ModFoodComponents.PALLID_WINGED_GRASSHOPPER_LEG)));
    public static final RegistryObject<Item> COOKED_PALLID_WINGED_GRASSHOPPER_LEG = ModItems.registerItem("cooked_pallid_winged_grasshopper_leg", () -> new Item(new Item.Properties().m_41489_(ModFoodComponents.COOKED_PALLID_WINGED_GRASSHOPPER_LEG)));
    public static final RegistryObject<Item> BARLEY_BREAD = ModItems.registerItem("barley_bread", () -> new Item(new Item.Properties().m_41489_(ModFoodComponents.BARLEY_BREAD)));
    public static final RegistryObject<Item> BARLEY_STEW = ModItems.registerItem("barley_stew", () -> new Item(new Item.Properties().m_41487_(1).m_41489_(ModFoodComponents.BARLEY_STEW)));
    public static final RegistryObject<Item> OAT_COOKIE = ModItems.registerItem("oat_cookie", () -> new Item(new Item.Properties().m_41489_(ModFoodComponents.OAT_COOKIE)));
    public static final RegistryObject<Item> OATMEAL = ModItems.registerItem("oatmeal", () -> new Item(new Item.Properties().m_41487_(1).m_41489_(ModFoodComponents.OATMEAL)));
    public static final RegistryObject<Item> STEPPE_VIPER_FANG = ModItems.registerItem("steppe_viper_fang", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> STEPPE_EAGLE_BEAK = ModItems.registerItem("steppe_eagle_beak", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> STEPPE_EAGLE_FEATHER = ModItems.registerItem("steppe_eagle_feather", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> FERRUGINOUS_HAWK_FEATHER = ModItems.registerItem("ferruginous_hawk_feather", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> BLACK_BILLED_MAGPIE_FEATHER = ModItems.registerItem("black_billed_magpie_feather", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> WESTERN_MEADOWLARK_FEATHER = ModItems.registerItem("western_meadowlark_feather", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> MARMOT_FUR = ModItems.registerItem("marmot_fur", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> SAIGA_HORN = ModItems.registerItem("saiga_horn", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> BISON_HORN = ModItems.registerItem("bison_horn", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> DARKLING_BEETLE_SHELL = ModItems.registerItem("darkling_beetle_shell", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> STEPPE_ARROW = ModItems.registerItem("steppe_arrow", () -> new SteppeArrowItem(new Item.Properties()));
    public static final RegistryObject<Item> STEPPE_VIPER_DAGGER = ModItems.registerItem("steppe_viper_dagger", () -> new SteppeViperDagger((Tier)Tiers.STONE, 2, -1.0f, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> SAIGA_SICKLE = ModItems.registerItem("saiga_sickle", () -> new SaigaSickle((Tier)Tiers.STONE, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> DARKLING_BEETLE_CHESTPLATE = ModItems.registerItem("darkling_beetle_chestplate", () -> new ArmorItem(ModArmorMaterials.DARKLING_BEETLE_SHELL, ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41503_(25)));
    public static final RegistryObject<Item> FURRED_LEATHER_HELMET = ModItems.registerItem("furred_leather_helmet", () -> new DyeableArmorItem(ModArmorMaterials.FURRED_LEATHER, ArmorItem.Type.HELMET, new Item.Properties().m_41503_(10)));
    public static final RegistryObject<Item> FURRED_LEATHER_CHESTPLATE = ModItems.registerItem("furred_leather_chestplate", () -> new DyeableArmorItem(ModArmorMaterials.FURRED_LEATHER, ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41503_(10)));
    public static final RegistryObject<Item> FURRED_LEATHER_LEGGINGS = ModItems.registerItem("furred_leather_leggings", () -> new DyeableArmorItem(ModArmorMaterials.FURRED_LEATHER, ArmorItem.Type.LEGGINGS, new Item.Properties().m_41503_(10)));
    public static final RegistryObject<Item> FURRED_LEATHER_BOOTS = ModItems.registerItem("furred_leather_boots", () -> new DyeableArmorItem(ModArmorMaterials.FURRED_LEATHER, ArmorItem.Type.BOOTS, new Item.Properties().m_41503_(10)));

    private static <T extends Item> RegistryObject<T> registerItem(String name, Supplier<T> item) {
        return ITEMS.register(name, item);
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }

    public static RegistryObject<Item> registerCropItem(String name) {
        return ModItems.registerItem(name + "_item", () -> new Item(new Item.Properties()));
    }

    public static RegistryObject<Item> registerBerryItem(String name, int nutrition, float saturation, RegistryObject<Block> block) {
        return ModItems.registerItem(name + "_item", () -> new ItemNameBlockItem((Block)block.get(), new Item.Properties().m_41487_(16).m_41489_(ModFoodComponents.registerFood(nutrition, saturation))));
    }

    public static RegistryObject<Item> registerSeedsItem(String name, RegistryObject<Block> block) {
        return ModItems.registerItem(name + "_seeds", () -> new ItemNameBlockItem((Block)block.get(), new Item.Properties()));
    }

    public static RegistryObject<Item> registerBoatItem(String name) {
        return ModItems.registerItem(name + "_boat", () -> new ModBoatItem(false, ModBoatEntity.Type.byName(name), new Item.Properties()));
    }

    public static RegistryObject<Item> registerChestBoatItem(String name) {
        return ModItems.registerItem(name + "_chest_boat", () -> new ModBoatItem(true, ModBoatEntity.Type.byName(name), new Item.Properties()));
    }

    public static RegistryObject<Item> registerSignItem(String name, Supplier<Block> signBlock, Supplier<Block> wallSignBlock) {
        return ModItems.registerItem(name + "_sign_item", () -> new SignItem(new Item.Properties().m_41487_(16), (Block)signBlock.get(), (Block)wallSignBlock.get()));
    }

    public static RegistryObject<Item> registerHangingSignItem(String name, Supplier<Block> hangingSignBlock, Supplier<Block> wallHangingSignBlock) {
        return ModItems.registerItem(name + "_hanging_sign_item", () -> new HangingSignItem((Block)hangingSignBlock.get(), (Block)wallHangingSignBlock.get(), new Item.Properties().m_41487_(16)));
    }

    static {
        for (String name : ModBlockSetsHelper.WOOD_NAMES) {
            ModBlockSetsHelper.WOODEN_SIGN_ITEMS.put(name, ModItems.registerSignItem(name, (Supplier)ModBlockSetsHelper.WOODEN_SIGNS.get(name), (Supplier)ModBlockSetsHelper.WOODEN_WALL_SIGNS.get(name)));
            ModBlockSetsHelper.WOODEN_HANGING_SIGN_ITEMS.put(name, ModItems.registerHangingSignItem(name, (Supplier)ModBlockSetsHelper.WOODEN_HANGING_SIGNS.get(name), (Supplier)ModBlockSetsHelper.WOODEN_WALL_HANGING_SIGNS.get(name)));
            ModBlockSetsHelper.WOODEN_BOATS.put(name, ModItems.registerBoatItem(name));
            ModBlockSetsHelper.WOODEN_CHEST_BOATS.put(name, ModItems.registerChestBoatItem(name));
        }
    }
}

