/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.item.custom;

import java.util.List;
import java.util.function.Predicate;
import net.alminoris.wildfields.entity.custom.ModBoatEntity;
import net.alminoris.wildfields.entity.custom.ModChestBoatEntity;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ModBoatItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.f_20408_.and(Entity::m_6087_);
    private final ModBoatEntity.Type type;
    private final boolean hasChest;

    public ModBoatItem(boolean pHasChest, ModBoatEntity.Type pType, Item.Properties pProperties) {
        super(pProperties);
        this.hasChest = pHasChest;
        this.type = pType;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        BlockHitResult hitresult = ModBoatItem.m_41435_((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        Vec3 vec3 = pPlayer.m_20252_(1.0f);
        List list = pLevel.m_6249_((Entity)pPlayer, pPlayer.m_20191_().m_82369_(vec3.m_82490_(5.0)).m_82400_(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec31 = pPlayer.m_146892_();
            for (Entity entity : list) {
                AABB aabb = entity.m_20191_().m_82400_((double)entity.m_6143_());
                if (!aabb.m_82390_(vec31)) continue;
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
        }
        if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
            Boat boat = this.getBoat(pLevel, (HitResult)hitresult);
            if (boat instanceof ModChestBoatEntity) {
                ModChestBoatEntity chestBoat = (ModChestBoatEntity)boat;
                chestBoat.setVariant(this.type);
            } else if (boat instanceof ModBoatEntity) {
                ((ModBoatEntity)boat).setVariant(this.type);
            }
            boat.m_146922_(pPlayer.m_146908_());
            if (!pLevel.m_45756_((Entity)boat, boat.m_20191_())) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            if (!pLevel.f_46443_) {
                pLevel.m_7967_((Entity)boat);
                pLevel.m_220400_((Entity)pPlayer, GameEvent.f_157810_, hitresult.m_82450_());
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)pLevel.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    private Boat getBoat(Level p_220017_, HitResult p_220018_) {
        return this.hasChest ? new ModChestBoatEntity(p_220017_, p_220018_.m_82450_().f_82479_, p_220018_.m_82450_().f_82480_, p_220018_.m_82450_().f_82481_) : new ModBoatEntity(p_220017_, p_220018_.m_82450_().f_82479_, p_220018_.m_82450_().f_82480_, p_220018_.m_82450_().f_82481_);
    }
}

