/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.world.gen.features.custom;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacer;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class TreeGroupFeature
extends Feature<TreeConfiguration> {
    private static final int BLOCK_UPDATE_FLAGS = 19;

    public TreeGroupFeature(Codec<TreeConfiguration> codec) {
        super(codec);
    }

    private static boolean isVine(LevelSimulatedReader world, BlockPos pos) {
        return world.m_7433_(pos, state -> state.m_60713_(Blocks.f_50191_));
    }

    public static boolean isAirOrLeaves(LevelSimulatedReader world, BlockPos pos) {
        return world.m_7433_(pos, state -> state.m_60795_() || state.m_204336_(BlockTags.f_13035_));
    }

    private static void setBlockKnownShape(LevelWriter world, BlockPos pos, BlockState state) {
        world.m_7731_(pos, state, 19);
    }

    public static boolean validTreePos(LevelSimulatedReader world, BlockPos pos) {
        return world.m_7433_(pos, state -> state.m_60795_() || state.m_204336_(BlockTags.f_278411_));
    }

    private boolean doPlace(WorldGenLevel world, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> rootPlacerReplacer, BiConsumer<BlockPos, BlockState> trunkPlacerReplacer, FoliagePlacer.FoliageSetter foliageSetter, TreeConfiguration config) {
        int i = config.f_68190_.m_226153_(random);
        int j = config.f_68189_.m_214116_(random, i, config);
        int k = i - j;
        int l = config.f_68189_.m_214117_(random, k);
        BlockPos blockPos = config.f_225455_.map(r -> r.m_225891_(pos, random)).orElse(pos);
        int minY = Math.min(pos.m_123342_(), blockPos.m_123342_());
        int maxY = Math.max(pos.m_123342_(), blockPos.m_123342_()) + i + 1;
        if (minY >= world.m_141937_() + 1 && maxY <= world.m_151558_()) {
            OptionalInt minClipped = config.f_68191_.m_68295_();
            int top = this.getMaxFreeTreeHeight((LevelSimulatedReader)world, i, blockPos, config);
            if (top >= i || !minClipped.isEmpty() && top >= minClipped.getAsInt()) {
                if (config.f_225455_.isPresent() && !((RootPlacer)config.f_225455_.get()).m_213684_((LevelSimulatedReader)world, rootPlacerReplacer, random, pos, blockPos, config)) {
                    return false;
                }
                List list = config.f_68190_.m_213934_((LevelSimulatedReader)world, trunkPlacerReplacer, random, top, blockPos, config);
                list.forEach(node -> config.f_68189_.m_271927_((LevelSimulatedReader)world, foliageSetter, random, config, top, node, j, l));
                return true;
            }
        }
        return false;
    }

    private int getMaxFreeTreeHeight(LevelSimulatedReader world, int height, BlockPos pos, TreeConfiguration config) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= height + 1; ++i) {
            int radius = config.f_68191_.m_6133_(height, i);
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    mutable.m_122154_((Vec3i)pos, dx, i, dz);
                    if (config.f_68190_.m_226184_(world, (BlockPos)mutable) && (config.f_68193_ || !TreeGroupFeature.isVine(world, (BlockPos)mutable))) continue;
                    return i - 2;
                }
            }
        }
        return height;
    }

    protected void m_5974_(LevelWriter world, BlockPos pos, BlockState state) {
        TreeGroupFeature.setBlockKnownShape(world, pos, state);
    }

    public final boolean m_142674_(FeaturePlaceContext<TreeConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        boolean success = false;
        success |= this.generateTree(world, random, origin, config);
        int count = 5 + random.m_188503_(3);
        int radius = 8 + random.m_188503_(5);
        for (int i = 0; i < count; ++i) {
            int dz;
            double angle = Math.PI * 2 * (double)i / (double)count + random.m_188500_();
            int dx = (int)(Math.cos(angle) * (double)radius);
            BlockPos offsetPos = origin.m_7918_(dx, 0, dz = (int)(Math.sin(angle) * (double)radius));
            BlockPos ground = TreeGroupFeature.findGround(world, offsetPos);
            if (ground == null) continue;
            success |= this.generateTree(world, random, ground, config);
        }
        return success;
    }

    private boolean generateTree(final WorldGenLevel world, RandomSource random, BlockPos pos, TreeConfiguration config) {
        HashSet set = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        final HashSet set3 = Sets.newHashSet();
        HashSet set4 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> biConsumer = (p, s) -> {
            set.add(p.m_7949_());
            world.m_7731_(p, s, 19);
        };
        BiConsumer<BlockPos, BlockState> biConsumer2 = (p, s) -> {
            set2.add(p.m_7949_());
            world.m_7731_(p, s, 19);
        };
        FoliagePlacer.FoliageSetter foliageSetter = new FoliagePlacer.FoliageSetter(){

            public void m_271838_(BlockPos p, BlockState s) {
                set3.add(p.m_7949_());
                world.m_7731_(p, s, 19);
            }

            public boolean m_271808_(BlockPos p) {
                return set3.contains(p);
            }
        };
        BiConsumer<BlockPos, BlockState> biConsumer3 = (p, s) -> {
            set4.add(p.m_7949_());
            world.m_7731_(p, s, 19);
        };
        boolean bl = this.doPlace(world, random, pos, biConsumer, biConsumer2, foliageSetter, config);
        if (!(!bl || set2.isEmpty() && set3.isEmpty())) {
            if (!config.f_68187_.isEmpty()) {
                TreeDecorator.Context context = new TreeDecorator.Context((LevelSimulatedReader)world, biConsumer3, random, (Set)set2, (Set)set3, (Set)set);
                config.f_68187_.forEach(d -> d.m_214187_(context));
            }
            return BoundingBox.m_162378_((Iterable)Iterables.concat((Iterable)set, (Iterable)set2, (Iterable)set3, (Iterable)set4)).map(box -> {
                DiscreteVoxelShape shape = TreeGroupFeature.updateLeaves((LevelAccessor)world, box, set2, set4, set);
                StructureTemplate.m_74510_((LevelAccessor)world, (int)3, (DiscreteVoxelShape)shape, (int)box.m_162395_(), (int)box.m_162396_(), (int)box.m_162398_());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private static BlockPos findGround(WorldGenLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        while (mutable.m_123342_() > world.m_141937_()) {
            if (!world.m_46859_((BlockPos)mutable)) {
                return mutable.m_7494_();
            }
            mutable.m_122173_(Direction.DOWN);
        }
        return null;
    }

    private static DiscreteVoxelShape updateLeaves(LevelAccessor world, BoundingBox box, Set<BlockPos> trunkPositions, Set<BlockPos> decorationPositions, Set<BlockPos> rootPositions) {
        BitSetDiscreteVoxelShape shape = new BitSetDiscreteVoxelShape(box.m_71056_(), box.m_71057_(), box.m_71058_());
        ArrayList list = Lists.newArrayList();
        for (int j = 0; j < 7; ++j) {
            list.add(Sets.newHashSet());
        }
        for (BlockPos blockPos : Lists.newArrayList((Iterable)Sets.union(decorationPositions, rootPositions))) {
            if (!box.m_71051_((Vec3i)blockPos)) continue;
            shape.m_142703_(blockPos.m_123341_() - box.m_162395_(), blockPos.m_123342_() - box.m_162396_(), blockPos.m_123343_() - box.m_162398_());
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int k = 0;
        ((Set)list.get(0)).addAll(trunkPositions);
        block2: while (true) {
            if (k >= 7 || !((Set)list.get(k)).isEmpty()) {
                if (k >= 7) {
                    return shape;
                }
                Iterator iterator = ((Set)list.get(k)).iterator();
                BlockPos bp = (BlockPos)iterator.next();
                iterator.remove();
                if (!box.m_71051_((Vec3i)bp)) continue;
                if (k != 0) {
                    BlockState state = world.m_8055_(bp);
                    TreeGroupFeature.setBlockKnownShape((LevelWriter)world, bp, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(k)));
                }
                shape.m_142703_(bp.m_123341_() - box.m_162395_(), bp.m_123342_() - box.m_162396_(), bp.m_123343_() - box.m_162398_());
                Direction[] directionArray = Direction.values();
                int n = directionArray.length;
                int n2 = 0;
                while (true) {
                    int o;
                    BlockState state2;
                    OptionalInt optional;
                    int mz;
                    int my;
                    int mx;
                    if (n2 >= n) continue block2;
                    Direction dir = directionArray[n2];
                    mutable.m_122159_((Vec3i)bp, dir);
                    if (box.m_71051_((Vec3i)mutable) && !shape.m_6696_(mx = mutable.m_123341_() - box.m_162395_(), my = mutable.m_123342_() - box.m_162396_(), mz = mutable.m_123343_() - box.m_162398_()) && !(optional = LeavesBlock.m_277200_((BlockState)(state2 = world.m_8055_((BlockPos)mutable)))).isEmpty() && (o = Math.min(optional.getAsInt(), k + 1)) < 7) {
                        ((Set)list.get(o)).add(mutable.m_7949_());
                        k = Math.min(k, o);
                    }
                    ++n2;
                }
            }
            ++k;
        }
    }
}

