/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.block;

import java.util.function.Supplier;
import net.alminoris.wildfields.block.custom.AnimalHideBlock;
import net.alminoris.wildfields.block.custom.BerryBushBlock;
import net.alminoris.wildfields.block.custom.BushLeavesBlock;
import net.alminoris.wildfields.block.custom.CottonwoodFluffBlock;
import net.alminoris.wildfields.block.custom.CustomCropBlock;
import net.alminoris.wildfields.block.custom.FallingLeavesBlock;
import net.alminoris.wildfields.block.custom.ModHangingSignBlock;
import net.alminoris.wildfields.block.custom.ModStandingSignBlock;
import net.alminoris.wildfields.block.custom.ModWallHangingSignBlock;
import net.alminoris.wildfields.block.custom.ModWallSignBlock;
import net.alminoris.wildfields.block.custom.PricklyPearCactusBlock;
import net.alminoris.wildfields.block.custom.TripleTallPlantBlock;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.particle.ModParticles;
import net.alminoris.wildfields.util.helper.ModBlockSetsHelper;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"wildfields");
    public static final RegistryObject<Block> THYME = ModBlocks.registerBlock("thyme", () -> new FlowerBlock(MobEffects.ABSORPTION, 200.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PEONY)));
    public static final RegistryObject<Block> POTTED_THYME = BLOCKS.register("potted_thyme", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, THYME, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_DANDELION)));
    public static final RegistryObject<Block> SPIDER_MILKWEED = ModBlocks.registerBlock("spider_milkweed", () -> new FlowerBlock(MobEffects.HEALTH_BOOST, 0.35f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PEONY)));
    public static final RegistryObject<Block> POTTED_SPIDER_MILKWEED = ModBlocks.registerBlock("potted_spider_milkweed", () -> new FlowerPotBlock((Block)SPIDER_MILKWEED.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_DANDELION)));
    public static final RegistryObject<Block> WORMWOOD = ModBlocks.registerBlock("wormwood", () -> new FlowerBlock(MobEffects.FIRE_RESISTANCE, 0.35f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PEONY)));
    public static final RegistryObject<Block> POTTED_WORMWOOD = ModBlocks.registerBlock("potted_wormwood", () -> new FlowerPotBlock((Block)WORMWOOD.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_DANDELION)));
    public static final RegistryObject<Block> PRAIRIE_ROSE = ModBlocks.registerBlock("prairie_rose", () -> new FlowerBlock(MobEffects.REGENERATION, 0.35f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PEONY)));
    public static final RegistryObject<Block> POTTED_PRAIRIE_ROSE = ModBlocks.registerBlock("potted_prairie_rose", () -> new FlowerPotBlock((Block)PRAIRIE_ROSE.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_DANDELION)));
    public static final RegistryObject<Block> SMOOTH_ASTER = ModBlocks.registerBlock("smooth_aster", () -> new FlowerBlock(MobEffects.REGENERATION, 0.35f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PEONY)));
    public static final RegistryObject<Block> POTTED_SMOOTH_ASTER = ModBlocks.registerBlock("potted_smooth_aster", () -> new FlowerPotBlock((Block)SMOOTH_ASTER.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_DANDELION)));
    public static final RegistryObject<Block> FEATHER_GRASS = ModBlocks.registerBlock("feather_grass", () -> new TallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS)));
    public static final RegistryObject<Block> GREEN_LICHEN = ModBlocks.registerBlock("green_lichen", () -> new VineBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.VINE)));
    public static final RegistryObject<Block> TINY_GRASS = ModBlocks.registerBlock("tiny_grass", () -> new TallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS)));
    public static final RegistryObject<Block> BLUE_GRAMA_GRASS = ModBlocks.registerBlock("blue_grama_grass", () -> new DoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS)));
    public static final RegistryObject<Block> PRAIRIE_SAGE = ModBlocks.registerBlock("prairie_sage", () -> new TripleTallPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS)));
    public static final RegistryObject<Block> SERVAL_HIDE = ModBlocks.registerBlock("serval_hide", () -> new AnimalHideBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.YELLOW_WOOL)));
    public static final RegistryObject<Block> VIOLA = ModBlocks.registerBlock("viola", () -> new PinkPetalsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PINK_PETALS)));
    public static final RegistryObject<Block> COTTONWOOD_FLUFF = ModBlocks.registerBlock("cottonwood_fluff", () -> new CottonwoodFluffBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).noCollission()));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }

    public static RegistryObject<Block> registerBushBlock(String name) {
        if (name.equals("prickly_pear")) {
            return ModBlocks.registerBlock(name, () -> new PricklyPearCactusBlock(name));
        }
        return ModBlocks.registerBlock(name, () -> new BerryBushBlock(name));
    }

    public static RegistryObject<Block> registerHayBlock(String name) {
        return ModBlocks.registerBlock(name + "_hay_block", () -> new HayBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).instrument(NoteBlockInstrument.BANJO).strength(0.5f).sound(SoundType.GRASS)));
    }

    public static RegistryObject<Block> registerWildCropBlock(String name) {
        return ModBlocks.registerBlock("wild_" + name, () -> new FlowerBlock(MobEffects.LUCK, 200.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS)));
    }

    public static RegistryObject<Block> registerCropBlock(String name) {
        return ModBlocks.registerBlock(name, () -> new CustomCropBlock(name));
    }

    public static RegistryObject<Block> registerStoneBlock(String name, String type) {
        return ModBlocks.registerBlock(name + "_" + type, () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).instrument(NoteBlockInstrument.BASEDRUM).strength(1.0f).sound(SoundType.STONE)));
    }

    public static RegistryObject<Block> registerStoneSlab(String name, String type) {
        return ModBlocks.registerBlock(name + (String)(type.equals("block") ? "" : "_" + type) + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)ModBlockSetsHelper.STONE_BLOCKS.get(name).get(type).get()))));
    }

    public static RegistryObject<Block> registerStoneStairs(String name, String type) {
        return ModBlocks.registerBlock(name + "_" + (String)(type.equals("block") ? "" : "_" + type) + "_stairs", () -> new StairBlock(((Block)ModBlockSetsHelper.STONE_BLOCKS.get(name).get(type).get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)ModBlockSetsHelper.STONE_BLOCKS.get(name).get(type).get()))));
    }

    public static RegistryObject<Block> registerStoneWall(String name, String type) {
        return ModBlocks.registerBlock(name + "_" + (String)(type.equals("block") ? "" : "_" + type) + "_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)ModBlockSetsHelper.STONE_BLOCKS.get(name).get(type).get()))));
    }

    public static RegistryObject<Block> registerLeavesBlock(String name) {
        if (name.equals("tamarisk")) {
            return ModBlocks.registerBlock(name + "_leaves", () -> new BushLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).noCollission()));
        }
        if (name.equals("olive")) {
            return ModBlocks.registerBlock(name + "_leaves", () -> new FallingLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES), ModParticles.OLIVE_LEAVES, 30));
        }
        if (name.equals("trembling_aspen")) {
            return ModBlocks.registerBlock(name + "_leaves", () -> new FallingLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES), ModParticles.TREMBLING_ASPEN_LEAVES, 50));
        }
        if (name.equals("cottonwood")) {
            return ModBlocks.registerBlock(name + "_leaves", () -> new FallingLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES), ModParticles.COTTONWOOD_LEAVES, 70));
        }
        return ModBlocks.registerBlock(name + "_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)));
    }

    public static RegistryObject<Block> registerLogsBlock(String name) {
        return ModBlocks.registerBlock(name + "_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG)));
    }

    public static RegistryObject<Block> registerWoodsBlock(String name) {
        return ModBlocks.registerBlock(name + "_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD)));
    }

    public static RegistryObject<Block> registerStrippedLogsBlock(String name) {
        return ModBlocks.registerBlock("stripped_" + name + "_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG)));
    }

    public static RegistryObject<Block> registerStrippedWoodsBlock(String name) {
        return ModBlocks.registerBlock("stripped_" + name + "_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD)));
    }

    public static RegistryObject<Block> registerPlanksBlock(String name) {
        return ModBlocks.registerBlock(name + "_planks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    }

    public static RegistryObject<Block> registerSlabBlock(String name) {
        return ModBlocks.registerBlock(name + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SLAB)));
    }

    public static RegistryObject<Block> registerStairsBlock(String name, RegistryObject<Block> planks) {
        return ModBlocks.registerBlock(name + "_stairs", () -> new StairBlock(((Block)planks.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_STAIRS)));
    }

    public static RegistryObject<Block> registerFenceBlock(String name) {
        return ModBlocks.registerBlock(name + "_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE)));
    }

    public static RegistryObject<Block> registerFenceGateBlock(String name) {
        return ModBlocks.registerBlock(name + "_fence_gate", () -> new FenceGateBlock(ModBlockSetsHelper.WOOD_TYPES.get(name), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE)));
    }

    public static RegistryObject<Block> registerDoorBlock(String name) {
        return ModBlocks.registerBlock(name + "_door", () -> new DoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR)));
    }

    public static RegistryObject<Block> registerTrapdoorBlock(String name) {
        return ModBlocks.registerBlock(name + "_trapdoor", () -> new TrapDoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR)));
    }

    public static RegistryObject<Block> registerButtonBlock(String name) {
        return ModBlocks.registerBlock(name + "_button", () -> new ButtonBlock(BlockSetType.OAK, 30, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_BUTTON)));
    }

    public static RegistryObject<Block> registerPressurePlateBlock(String name) {
        return ModBlocks.registerBlock(name + "_pressure_plate", () -> new PressurePlateBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE)));
    }

    public static RegistryObject<Block> registerSaplingBlock(String name, TreeGrower saplingGenerator) {
        return ModBlocks.registerBlock(name + "_sapling", () -> new SaplingBlock(saplingGenerator, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
    }

    public static RegistryObject<Block> registerSignBlock(String name) {
        return ModBlocks.registerBlock(name + "_sign", () -> new ModStandingSignBlock(ModBlockSetsHelper.WOOD_TYPES.get(name), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SIGN)));
    }

    public static RegistryObject<Block> registerWallSignBlock(String name) {
        return ModBlocks.registerBlock(name + "_wall_sign", () -> new ModWallSignBlock(ModBlockSetsHelper.WOOD_TYPES.get(name), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_SIGN)));
    }

    public static RegistryObject<Block> registerHangingSignBlock(String name) {
        return ModBlocks.registerBlock(name + "_hanging_sign", () -> new ModHangingSignBlock(ModBlockSetsHelper.WOOD_TYPES.get(name), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_HANGING_SIGN)));
    }

    public static RegistryObject<Block> registerWallHangingSignBlock(String name) {
        return ModBlocks.registerBlock(name + "_wall_hanging_sign", () -> new ModWallHangingSignBlock(ModBlockSetsHelper.WOOD_TYPES.get(name), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_HANGING_SIGN)));
    }
}

