/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.block.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;

public class FallingLeavesBlock
extends LeavesBlock {
    public static final MapCodec<FallingLeavesBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FallingLeavesBlock.propertiesCodec(), (App)Codec.INT.fieldOf("falling_probability").forGetter(block -> block.fallingProbability)).apply((Applicative)instance, (props, probability) -> new FallingLeavesBlock((BlockBehaviour.Properties)props, null, (int)probability)));
    private final RegistryObject<SimpleParticleType> particleType;
    private final int fallingProbability;

    public FallingLeavesBlock(BlockBehaviour.Properties properties, RegistryObject<SimpleParticleType> particleType, int fallingProbability) {
        super(properties);
        this.particleType = particleType;
        this.fallingProbability = fallingProbability;
    }

    public MapCodec<? extends FallingLeavesBlock> codec() {
        return CODEC;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockPos below;
        BlockState belowState;
        super.animateTick(state, level, pos, random);
        if (this.particleType == null || this.particleType.get() == null) {
            return;
        }
        if (random.nextInt(this.fallingProbability) == 0 && !(belowState = level.getBlockState(below = pos.below())).isFaceSturdy((BlockGetter)level, below, Direction.UP)) {
            ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)pos, (RandomSource)random, (ParticleOptions)((ParticleOptions)this.particleType.get()));
        }
    }
}

