/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class TripleTallPlantBlock
extends Block {
    public static final EnumProperty<PlantPart> PART = EnumProperty.create((String)"part", PlantPart.class);

    public TripleTallPlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)((Object)PlantPart.LOWER)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART});
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean moving) {
        if (level.isClientSide) {
            return;
        }
        if (state.getValue(PART) == PlantPart.LOWER) {
            BlockPos middlePos = pos.above();
            BlockPos upperPos = pos.above(2);
            boolean middleFree = level.getBlockState(middlePos).canBeReplaced();
            boolean upperFree = level.getBlockState(upperPos).canBeReplaced();
            if (middleFree && upperFree) {
                level.setBlock(middlePos, (BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)PlantPart.MIDDLE)), 3);
                level.setBlock(upperPos, (BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)PlantPart.UPPER)), 3);
            } else {
                level.destroyBlock(pos, false);
            }
        }
        super.onPlace(state, level, pos, oldState, moving);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        PlantPart part = (PlantPart)((Object)state.getValue(PART));
        BlockPos basePos = switch (part.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> pos;
            case 1 -> pos.below();
            case 2 -> pos.below(2);
        };
        for (int i = 0; i < 3; ++i) {
            BlockPos target = basePos.above(i);
            BlockState targetState = level.getBlockState(target);
            if (targetState.getBlock() != this) continue;
            level.destroyBlock(target, !player.isCreative());
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public static enum PlantPart implements StringRepresentable
    {
        LOWER,
        MIDDLE,
        UPPER;


        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

