/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.datagen;

import java.util.Set;
import net.alminoris.wildfields.block.ModBlocks;
import net.alminoris.wildfields.block.custom.BerryBushBlock;
import net.alminoris.wildfields.block.custom.TripleTallPlantBlock;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.util.helper.ModBlockSetsHelper;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockLootTableProvider
extends BlockLootSubProvider {
    protected ModBlockLootTableProvider(HolderLookup.Provider pRegistries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), pRegistries);
    }

    protected void generate() {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        for (String name : ModBlockSetsHelper.WOOD_NAMES) {
            this.dropSelf((Block)ModBlockSetsHelper.LOGS.get(name).get());
            this.dropSelf((Block)ModBlockSetsHelper.STRIPPED_LOGS.get(name).get());
            this.dropSelf((Block)ModBlockSetsHelper.WOODS.get(name).get());
            this.dropSelf((Block)ModBlockSetsHelper.STRIPPED_WOODS.get(name).get());
            this.dropSelf((Block)ModBlockSetsHelper.WOODEN_PLANKS.get(name).get());
            this.add((Block)ModBlockSetsHelper.WOODEN_SLABS.get(name).get(), block -> this.createSlabItemTable((Block)ModBlockSetsHelper.WOODEN_SLABS.get(name).get()));
            this.dropSelf((Block)ModBlockSetsHelper.WOODEN_STAIRS.get(name).get());
            this.dropSelf((Block)ModBlockSetsHelper.WOODEN_FENCES.get(name).get());
            this.dropSelf((Block)ModBlockSetsHelper.WOODEN_FENCE_GATES.get(name).get());
            this.dropSelf((Block)ModBlockSetsHelper.WOODEN_TRAPDOORS.get(name).get());
            this.dropSelf((Block)ModBlockSetsHelper.WOODEN_BUTTONS.get(name).get());
            this.dropSelf((Block)ModBlockSetsHelper.WOODEN_PRESSURE_PLATES.get(name).get());
            this.add((Block)ModBlockSetsHelper.WOODEN_DOORS.get(name).get(), block -> this.createDoorTable((Block)ModBlockSetsHelper.WOODEN_DOORS.get(name).get()));
            this.dropSelf((Block)ModBlockSetsHelper.WOODEN_SAPLINGS.get(name).get());
            this.add((Block)ModBlockSetsHelper.LEAVES.get(name).get(), block -> this.createLeavesDrops((Block)block, (Block)ModBlockSetsHelper.WOODEN_SAPLINGS.get(name).get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.add((Block)ModBlockSetsHelper.WOODEN_SIGNS.get(name).get(), block -> this.createSingleItemTable((ItemLike)ModBlockSetsHelper.WOODEN_SIGN_ITEMS.get(name).get()));
            this.add((Block)ModBlockSetsHelper.WOODEN_WALL_SIGNS.get(name).get(), block -> this.createSingleItemTable((ItemLike)ModBlockSetsHelper.WOODEN_SIGN_ITEMS.get(name).get()));
            this.add((Block)ModBlockSetsHelper.WOODEN_HANGING_SIGNS.get(name).get(), block -> this.createSingleItemTable((ItemLike)ModBlockSetsHelper.WOODEN_HANGING_SIGN_ITEMS.get(name).get()));
            this.add((Block)ModBlockSetsHelper.WOODEN_WALL_HANGING_SIGNS.get(name).get(), block -> this.createSingleItemTable((ItemLike)ModBlockSetsHelper.WOODEN_HANGING_SIGN_ITEMS.get(name).get()));
        }
        this.add((Block)ModBlocks.FEATHER_GRASS.get(), x$0 -> this.createGrassDrops((Block)x$0));
        this.add((Block)ModBlocks.TINY_GRASS.get(), this::createTinyGrassDrops);
        this.add((Block)ModBlocks.BLUE_GRAMA_GRASS.get(), x$0 -> this.createDoublePlantShearsDrop((Block)x$0));
        this.add((Block)ModBlocks.PRAIRIE_SAGE.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)TripleTallPlantBlock.PART, (Comparable)((Object)TripleTallPlantBlock.PlantPart.LOWER)));
        this.dropSelf((Block)ModBlocks.THYME.get());
        this.dropSelf((Block)ModBlocks.SPIDER_MILKWEED.get());
        this.dropSelf((Block)ModBlocks.WORMWOOD.get());
        this.dropSelf((Block)ModBlocks.COTTONWOOD_FLUFF.get());
        this.dropSelf((Block)ModBlocks.PRAIRIE_ROSE.get());
        this.dropSelf((Block)ModBlocks.SMOOTH_ASTER.get());
        this.dropPottedContents((Block)ModBlocks.POTTED_THYME.get());
        this.dropPottedContents((Block)ModBlocks.POTTED_SPIDER_MILKWEED.get());
        this.dropPottedContents((Block)ModBlocks.POTTED_WORMWOOD.get());
        this.dropPottedContents((Block)ModBlocks.POTTED_PRAIRIE_ROSE.get());
        this.dropPottedContents((Block)ModBlocks.POTTED_SMOOTH_ASTER.get());
        this.add((Block)ModBlocks.SERVAL_HIDE.get(), block -> this.createSilkTouchOnlyTable((ItemLike)ModBlocks.SERVAL_HIDE.get()));
        for (String name : ModBlockSetsHelper.WILD_CROP_NAMES) {
            this.dropSelf((Block)ModBlockSetsHelper.WILD_CROPS.get(name).get());
        }
        for (String name : ModBlockSetsHelper.CROP_NAMES) {
            this.dropSelf((Block)ModBlockSetsHelper.HAY_BLOCKS.get(name).get());
            LootItemBlockStatePropertyCondition.Builder lootItemCondition$builder1 = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)ModBlockSetsHelper.CROPS.get(name).get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CropBlock.AGE, 7));
            this.add((Block)ModBlockSetsHelper.CROPS.get(name).get(), this.createCropDrops((Block)ModBlockSetsHelper.CROPS.get(name).get(), (Item)ModBlockSetsHelper.CROP_ITEMS.get(name).get(), (Item)ModBlockSetsHelper.CROP_SEEDS.get(name).get(), (LootItemCondition.Builder)lootItemCondition$builder1));
        }
        for (String name : ModBlockSetsHelper.BUSHES_NAMES) {
            this.add((Block)ModBlockSetsHelper.BUSHES.get(name).get(), p_249159_ -> (LootTable.Builder)this.applyExplosionDecay((ItemLike)p_249159_, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)ModBlockSetsHelper.BUSHES.get(name).get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BerryBushBlock.AGE, 3))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModBlockSetsHelper.BERRIES.get(name).get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)ModBlockSetsHelper.BUSHES.get(name).get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BerryBushBlock.AGE, 2))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModBlockSetsHelper.BERRIES.get(name).get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE))))));
        }
        this.add((Block)ModBlocks.GREEN_LICHEN.get(), block -> this.createSilkTouchOnlyTable((ItemLike)ModBlocks.GREEN_LICHEN.get()));
        for (String name : ModBlockSetsHelper.STONE_NAMES) {
            this.add((Block)ModBlockSetsHelper.STONE_BLOCKS.get(name).get("block").get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)ModBlockSetsHelper.STONE_BLOCKS.get(name).get("cobbled").get()));
            for (String type : ModBlockSetsHelper.STONE_TYPES) {
                if (!type.equals("block")) {
                    this.dropSelf((Block)ModBlockSetsHelper.STONE_BLOCKS.get(name).get(type).get());
                }
                this.dropSelf((Block)ModBlockSetsHelper.STONE_SLABS.get(name).get(type).get());
                this.dropSelf((Block)ModBlockSetsHelper.STONE_STAIRS.get(name).get(type).get());
                this.dropSelf((Block)ModBlockSetsHelper.STONE_WALLS.get(name).get(type).get());
            }
        }
        this.dropSelf((Block)ModBlocks.VIOLA.get());
        this.add((Block)ModBlockSetsHelper.LEAVES.get("olive").get(), block -> this.createLeavesItemDrops((Block)block, (Block)ModBlockSetsHelper.WOODEN_SAPLINGS.get("olive").get(), (Item)ModItems.OLIVES.get(), 0.0025f));
    }

    protected Iterable<Block> getKnownBlocks() {
        return ModBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
    }

    private LootTable.Builder createTinyGrassDrops(Block withShears) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createShearsDispatchTable(withShears, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)withShears, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WHEAT_SEEDS).when(LootItemRandomChanceCondition.randomChance((float)0.025f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (int)2))));
    }

    private LootTable.Builder createLeavesItemDrops(Block block, Block drop, Item item, float ... chances) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createLeavesDrops(block, drop, chances).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.SHEARS})).or(this.hasSilkTouch()).invert()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)item))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f}))));
    }
}

